/*
  * arch/mips/vr7701/cmb-vr7701/setup.c
  *
  * The setup file for CMB-VR7701 board.
  *
  * Author: MontaVista Software, Inc. <source@mvista.com>
  *
  * 2003 (c) MontaVista Software, Inc. This file is licensed under
  * the terms of the GNU General Public License version 2. This program
  * is licensed "as is" without any warranty of any kind, whether express
  * or implied.
  */

#include <linux/config.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/irq.h>
#include <linux/interrupt.h>
#include <linux/serial.h>
#include <linux/types.h>
#include <linux/string.h>
#include <linux/pci.h>
#include <linux/mtd/physmap.h>

#include <asm/bootinfo.h>
#include <asm/reboot.h>
#include <asm/io.h>
#include <asm/time.h>
#include <asm/pgtable.h>
#include <asm/processor.h>
#include <asm/reboot.h>
#include <asm/system.h>
#include <asm/vr7701.h>
#ifdef CONFIG_BLK_DEV_FD
#include <asm/floppy.h>
#endif
#if defined(CONFIG_BLK_DEV_IDE) || defined(CONFIG_BLK_DEV_IDE_MODULE)
#include <linux/ide.h>
#include <asm/hdreg.h>
#include <asm/ide.h>
#endif
#ifdef CONFIG_PC_KEYB
#include <asm/keyboard.h>
#endif
#ifdef CONFIG_VT
#include <linux/console.h>
#endif

#if defined(CONFIG_MTD)
static struct mtd_partition cmbvr7701_mtd_parts[] __initdata = {
	{
	 .name = "free space",
	 .offset = 0x0,
	 .size = 0x00f00000},
	{
	 .name = "PMON board info",
	 .offset = 0x00f00000,
	 .size = 0x00100000,
	 .mask_flags = MTD_WRITEABLE},
	{
	 .name = "User FS",
	 .offset = 0x01000000,
	 .size = 0x01000000},
};
#define part_num  (sizeof(cmbvr7701_mtd_parts)/sizeof(struct mtd_partition))
#endif

extern struct fd_ops std_fd_ops;
extern struct ide_ops std_ide_ops;
extern struct kbd_ops std_kbd_ops;
extern struct rtc_ops std_rtc_ops;

void
cmb_vr7701_restart(char *command)
{
	set_c0_status(ST0_BEV | ST0_ERL);
	change_c0_config(CONF_CM_CMASK, CONF_CM_UNCACHED);
	flush_cache_all();
	write_c0_wired(0);
	__asm__ __volatile__("jr\t%0"::"r"(0xbfc00000));
}

void
cmb_vr7701_halt(void)
{
	printk(KERN_NOTICE "\n** You can safely turn off the power\n");
	while (1) ;
}

void
cmb_vr7701_power_off(void)
{
	cmb_vr7701_halt();
}

static void __init
cmb_vr7701_time_init(void)
{
	/* 
	 * If PClock / SysClk == 2.5, then CPU frequency is 375MHz,
	 * else CPU frequency is 400MHz.
	 */
#define PCLOCK_FREQUENCY_25  375000000
#define PCLOCK_FREQUENCY_GEN 400000000

	/* 
	 * CP0 counter incremented in synchronization with the
	 * frequency 1/2 of PClock 
	 */
	if (read_c0_conf() >> 28 == 1)
		mips_counter_frequency = PCLOCK_FREQUENCY_25 / 2;
	else
		mips_counter_frequency = PCLOCK_FREQUENCY_GEN / 2;
}

extern int setup_irq(unsigned int irq, struct irqaction *irqaction);
static void __init
cmb_vr7701_timer_setup(struct irqaction *irq)
{

	unsigned int count;

	setup_irq(VR7701_CPU_TIMER, irq);

	/* to generate the first CPU timer interrupt */
	count = read_c0_count();
	write_c0_compare(count + 1000);
}

extern void vr7701_pci_setup(void);

extern int rockhopper_detect(struct pci_ops *ops);
extern int rockhopper_init(struct pci_ops *ops);
extern void vr7701_init_serial(void);
extern void rtc_ds1386_init(unsigned long base);

extern struct pci_ops vr7701_pci_ops;

void __init
nec_cmbvr7701_setup(void)
{
	board_time_init = cmb_vr7701_time_init;
	board_timer_setup = cmb_vr7701_timer_setup;

	_machine_restart = cmb_vr7701_restart;
	_machine_halt = cmb_vr7701_halt;
	_machine_power_off = cmb_vr7701_power_off;

	vr7701_init_serial();
	vr7701_pci_setup();

#ifdef CONFIG_VT
	conswitchp = &dummy_con;
#endif
#ifdef CONFIG_ROCKHOPPER
	if (rockhopper_detect(&vr7701_pci_ops)) {
		printk("Rockhopper baseboard detected; changing the "
		       "machine type\n");
		mips_machtype = MACH_NEC_CMB_VR7701_ROCKHOPPERII;
	}
	if (mips_machtype == MACH_NEC_CMB_VR7701_ROCKHOPPERII) {
		rockhopper_init(&vr7701_pci_ops);
#if defined(CONFIG_BLK_DEV_IDE) || defined(CONFIG_BLK_DEV_IDE_MODULE)
		ide_ops = &std_ide_ops;
#endif
#ifdef CONFIG_BLK_DEV_FD
		fd_ops = &std_fd_ops;
#endif
#ifdef CONFIG_PC_KEYB
		kbd_ops = &std_kbd_ops;
#endif
		rtc_ds1386_init(0xB9000000);
	}
#endif

#if defined(CONFIG_MTD)
	/* we use generic physmap mapping driver and we use partitions */
	physmap_configure(0x1A000000, 0x02000000, 4, NULL);
	physmap_set_partitions(cmbvr7701_mtd_parts, part_num);
#endif
}
