/*
  * arch/mips/vr7701/cmb-vr7701/prom.c
  *
  * The prom setup file for CMB-VR7701 evaluation board.
  *
  * Author: MontaVista Software, Inc. <source@mvista.com>
  *
  * 2003 (c) MontaVista Software, Inc. This file is licensed under
  * the terms of the GNU General Public License version 2. This program
  * is licensed "as is" without any warranty of any kind, whether express
  * or implied.
  */

#include <linux/init.h>
#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/string.h>
#include <linux/mm.h>
#include <linux/bootmem.h>

#include <asm/bootinfo.h>
#include <asm/addrspace.h>

char arcs_cmdline[CL_SIZE];

const char *
get_system_type(void)
{
	return "NEC CMB-VR7701";
}

void __init
prom_init(int argc, char **argv)
{
	int i;

	/*
	 * collect args and prepare cmd_line
	 */
	for (i = 1; i < argc; i++) {
		strcat(arcs_cmdline, argv[i]);
		if (i < (argc - 1))
			strcat(arcs_cmdline, " ");
	}

	strcat(arcs_cmdline, " console=ttyS0,115200");
	strcat(arcs_cmdline, " ip=bootp");
#if defined(CONFIG_BLK_DEV_IDE) && defined(CONFIG_ROCKHOPPER)
	strcat(arcs_cmdline, " ide0=autotune ide1=autotune");
#endif

	mips_machgroup = MACH_GROUP_NEC_VR7701;
	mips_machtype = MACH_NEC_CMB_VR7701;

	/* CMB-VR7701 board has 128 MB ram */
	add_memory_region(0, 128 << 20, BOOT_MEM_RAM);
}

extern char _ftext;

/* Free memory used by PMON boot loader */
void __init
prom_free_prom_memory(void)
{
}

void __init
prom_fixup_mem_map(unsigned long start, unsigned long end)
{
}
