/*
  * arch/mips/vr7701/cmb-vr7701/lcd44780.h
  *
  * Simple driver for a memory-mapped 44780-style LCD display.
  * Configured for CMB-VR7701/Rockhopper
  *
  * Author: MontaVista Software, Inc. <source@mvista.com>
  *
  * Based on:
  * Copyright 2001 Bradley D. LaRonde <brad@ltc.com>
  *
  * 2003 (c) MontaVista Software, Inc. This file is licensed under
  * the terms of the GNU General Public License version 2. This program
  * is licensed "as is" without any warranty of any kind, whether express
  * or implied.
  */
#ifndef _CMB_VR7701_LCD44780_H
#define _CMB_VR7701_LCD44780_H

/* Commands values. May be used as ioctl args. */
#define LCD44780_4BIT_1LINE        0x20
#define LCD44780_4BIT_2LINE        0x28
#define LCD44780_8BIT_1LINE        0x30
#define LCD44780_8BIT_2LINE        0x38
#define LCD44780_MODE_DEC          0x04
#define LCD44780_MODE_DEC_SHIFT    0x05
#define LCD44780_MODE_INC          0x06
#define LCD44780_MODE_INC_SHIFT    0x07
#define LCD44780_SCROLL_LEFT       0x18
#define LCD44780_SCROLL_RIGHT      0x1e
#define LCD44780_CURSOR_UNDERLINE  0x0e
#define LCD44780_CURSOR_BLOCK      0x0f
#define LCD44780_CURSOR_OFF        0x0c
#define LCD44780_CLEAR             0x01
#define LCD44780_BLANK             0x08
#define LCD44780_RESTORE           0x0c  // Same as CURSOR_OFF
#define LCD44780_HOME              0x02
#define LCD44780_LEFT              0x10
#define LCD44780_RIGHT             0x14

/* These commands to be or'ed with address values */
#define LCD44780_CG_ADDRESS        0x40
#define LCD44780_DD_ADDRESS        0x80

/* 
 * Ioctl commands to make an instruction or 
 * read/write from/to Data Register 
 */
#define LCD_IOCTL_ACTION            0x1
#define LCD_IOCTL_READ              0x2
#define LCD_IOCTL_WRITE             0x3

#endif /* _CMB_VR7701_LCD44780_H */
