/*
  * arch/mips/vr7701/cmb-vr7701/candy_setup.c
  *
  * NEC Candy ether driver board-specific setup routine.
  *
  * Author: MontaVista Software, Inc. <source@mvista.com>
  *
  * 2003 (c) MontaVista Software, Inc. This file is licensed under
  * the terms of the GNU General Public License version 2. This program
  * is licensed "as is" without any warranty of any kind, whether express
  * or implied.
  */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/init.h>
#include <asm/vr7701.h>

#define		MAX_NUM_DEVS		2

static struct {
	uint irq;
	ulong base_addr;
	ulong pmd_addr;
	u_char mac_addr[6];
} candy_boot_params[MAX_NUM_DEVS] = {
	{
		VR7701_IRQ_ETH, VR7701_BASE_VIRT + VR7701_ETHERNET1_BASE, 0, {
	0x00, 0x00, 0x4c, 0x80, 0x63, 0xad}}, {
		VR7701_IRQ_ETH, VR7701_BASE_VIRT + VR7701_ETHERNET2_BASE, 0, {
	0x00, 0x00, 0x4c, 0x80, 0x63, 0xae}}
};

int
nec_candy_get_boot_params(uint * irq,
			  ulong * base_addr,
			  ulong * pmd_addr, u_char * mac_addr)
{
	static int index = 0;
	int i;

	if (index == MAX_NUM_DEVS)
		return -1;

	*irq = candy_boot_params[index].irq;
	*base_addr = candy_boot_params[index].base_addr;
	*pmd_addr = candy_boot_params[index].pmd_addr;
	for (i = 0; i < 6; i++)
		mac_addr[i] = candy_boot_params[index].mac_addr[i];

	index++;
	return 0;
}

EXPORT_SYMBOL(nec_candy_get_boot_params);

/*
 * kernel boot parameters
 * format: "nec_candy_mac=xx,xx,xx,xx,xx,xx [nec_candy_mac=xx,xx,xx,xx,xx,xx]"
 */
static int __init
nec_candy_boot_setup(char *str)
{
	int ints[10];
	int i;
	static int index = 0;

	str = get_options(str, ARRAY_SIZE(ints), ints);

	if (ints[0] != 6)
		return 0;

	if (index == MAX_NUM_DEVS)
		return 1;	/* ignore params */

	for (i = 0; i < 6; i++)
		candy_boot_params[index].mac_addr[i] = (u_char) ints[i + 1];

	index++;
	return 1;
}

__setup("nec_candy_mac=", nec_candy_boot_setup);
