/*
 * arch/mips/vr41xx/nec-cmbvr41xx/setup.c
 *
 * Setup for the NEC CMB-VR4122/VR4131.
 *
 * Author: Yoichi Yuasa <yyuasa@mvista.com, or source@mvista.com>
 *
 * 2001-2003 (c) MontaVista, Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#include <linux/config.h>
#include <linux/init.h>
#include <linux/console.h>
#include <linux/ide.h>
#include <linux/ioport.h>

#include <asm/floppy.h>
#include <asm/keyboard.h>
#include <asm/pci_channel.h>
#include <asm/reboot.h>
#include <asm/time.h>
#include <asm/vr41xx/cmbvr41xx.h>

#ifdef CONFIG_BLK_DEV_INITRD
extern unsigned long initrd_start, initrd_end;
extern void * __rd_start, * __rd_end;
#endif

#ifdef CONFIG_PCI
static struct resource vr41xx_pci_io_resource = {
	"PCI I/O space",
	VR41XX_PCI_IO_START,
	VR41XX_PCI_IO_END,
	IORESOURCE_IO
};

static struct resource vr41xx_pci_mem_resource = {
	"PCI memory space",
	VR41XX_PCI_MEM_START,
	VR41XX_PCI_MEM_END,
	IORESOURCE_MEM
};

extern struct pci_ops vr41xx_pci_ops;

struct pci_channel mips_pci_channels[] = {
	{&vr41xx_pci_ops, &vr41xx_pci_io_resource, &vr41xx_pci_mem_resource, 0, 256},
	{NULL, NULL, NULL, 0, 0}
};

struct vr41xx_pci_address_space vr41xx_pci_mem1 = {
	VR41XX_PCI_MEM1_BASE,
	VR41XX_PCI_MEM1_MASK,
	IO_MEM1_RESOURCE_START
};

struct vr41xx_pci_address_space vr41xx_pci_mem2 = {
	VR41XX_PCI_MEM2_BASE,
	VR41XX_PCI_MEM2_MASK,
	IO_MEM2_RESOURCE_START
};

struct vr41xx_pci_address_space vr41xx_pci_io = {
	VR41XX_PCI_IO_BASE,
	VR41XX_PCI_IO_MASK,
	IO_PORT_RESOURCE_START
};

static struct vr41xx_pci_address_map pci_address_map = {
	&vr41xx_pci_mem1,
	&vr41xx_pci_mem2,
	&vr41xx_pci_io
};

extern void ali_m5229_preinit(void);
#endif

#ifdef CONFIG_PC_KEYB
extern struct kbd_ops cmbvr41xx_kbd_ops;
#endif

#ifdef CONFIG_BLK_DEV_FD
extern struct fd_ops std_fd_ops;
#endif

#ifdef CONFIG_BLK_DEV_IDE
extern struct ide_ops cmbvr41xx_ide_ops;
#endif

void __init nec_cmbvr41xx_setup(void)
{
	set_io_port_base(IO_PORT_BASE);
	ioport_resource.start = IO_PORT_RESOURCE_START;
	ioport_resource.end = IO_PORT_RESOURCE_END;
	iomem_resource.start = IO_MEM1_RESOURCE_START;
	iomem_resource.end = IO_MEM2_RESOURCE_END;

#ifdef CONFIG_BLK_DEV_INITRD
	ROOT_DEV = MKDEV(RAMDISK_MAJOR, 0);
	initrd_start = (unsigned long)&__rd_start;
	initrd_end = (unsigned long)&__rd_end;
#endif

	_machine_restart = vr41xx_restart;
	_machine_halt = vr41xx_halt;
	_machine_power_off = vr41xx_power_off;

	board_time_init = vr41xx_time_init;
	board_timer_setup = vr41xx_timer_setup;

	rtc_ds1386_init(KSEG1ADDR(0x0a000000));

	board_irq_init = cmbvr41xx_irq_init;

#ifdef CONFIG_FB
	conswitchp = &dummy_con;
#endif

#ifdef CONFIG_PC_KEYB
	kbd_ops = &cmbvr41xx_kbd_ops;
#endif

#ifdef CONFIG_BLK_DEV_FD
	fd_ops = &std_fd_ops;
#endif

#ifdef CONFIG_BLK_DEV_IDE
	ide_ops = &cmbvr41xx_ide_ops;
#endif

	vr41xx_bcu_init();

	vr41xx_cmu_init(0);

	vr41xx_siu_init(SIU_RS232C, 0);
#ifdef CONFIG_KGDB
	vr41xx_dsiu_debug_init(BAUD_RATE_38400, DATA_8BIT, PARITY_NONE, STOP_1BIT);
#else
	vr41xx_dsiu_init();
#endif

#ifdef CONFIG_PCI
	vr41xx_pciu_init(&pci_address_map);

	ali_m5229_preinit();
#endif
}
