/*
 * arch/mips/vr41xx/nec-cmbvr41xx/serial.c
 *
 * Serial Interface initial routines for ALi M1535+.
 *
 * Author: Yoichi Yuasa <yyuasa@mvista.com, or source@mvista.com>
 *
 * 2003 (c) MontaVista, Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */

#include <linux/init.h>
#include <linux/types.h>
#include <linux/serial.h>

#include <asm/vr41xx/cmbvr41xx.h>

#define BASE_BAUD	( 1843200 / 16 )

extern int vr41xx_serial_ports;

void __init ali_m1535plus_uart1_init(void)
{
	struct serial_struct s;

	memset(&s, 0, sizeof(s));

	s.line = vr41xx_serial_ports;
	s.baud_base = BASE_BAUD;
	s.port = 0x3f8;
	s.irq = UART1_IRQ;
	s.flags = ASYNC_BOOT_AUTOCONF | ASYNC_SKIP_TEST;
	s.io_type = SERIAL_IO_PORT;
	if (early_serial_setup(&s) != 0)
		printk(KERN_ERR "ALi M1535+ UART1 setup failed!\n");

	vr41xx_serial_ports++;
}

void __init ali_m1535plus_uart3_init(void)
{
	struct serial_struct s;

	memset(&s, 0, sizeof(s));

	s.line = vr41xx_serial_ports;
	s.baud_base = BASE_BAUD;
	s.port = 0x2f8;
	s.irq = UART3_IRQ;
	s.flags = ASYNC_BOOT_AUTOCONF | ASYNC_SKIP_TEST;
	s.io_type = SERIAL_IO_PORT;
	if (early_serial_setup(&s) != 0)
		printk(KERN_ERR "ALi M1535+ UART3 setup failed!\n");

	vr41xx_serial_ports++;
}
