/*
 * arch/mips/vr41xx/nec-cmbvr41xx/pci_fixup.c
 *
 * The NEC CMB-VR4122/VR4131 Board specific PCI fixups.
 *
 * Author: Yoichi Yuasa <yyuasa@mvista.com, or source@mvista.com>
 *
 * 2003 (c) MontaVista, Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#include <linux/config.h>
#include <linux/init.h>
#include <linux/pci.h>

#include <asm/vr41xx/cmbvr41xx.h>

extern void ali_m1535plus_init(struct pci_dev *dev);
extern void ali_m5229_init(struct pci_dev *dev);

void __init pcibios_fixup_resources(struct pci_dev *dev)
{
	if (dev->vendor ==  PCI_VENDOR_ID_AL) {
		switch (dev->device) {
		case PCI_DEVICE_ID_AL_M1533:
			ali_m1535plus_init(dev);
			break;
		case PCI_DEVICE_ID_AL_M5229:
			ali_m5229_init(dev);
			break;
		case PCI_DEVICE_ID_AL_M5237:
			break;
		}
	}
}

void __init pcibios_fixup(void)
{
}

void __init pcibios_fixup_irqs(void)
{
	struct pci_dev *dev;
	u8 slot, func, pin;

	pci_for_each_dev(dev) {
		slot = PCI_SLOT(dev->devfn);
		func = PCI_FUNC(dev->devfn);
		pci_read_config_byte(dev, PCI_INTERRUPT_PIN, &pin);
		dev->irq = 0;

		switch (dev->bus->number) {
		/*
		 * PCI Bus 0
		 */
		case 0:
			switch (slot) {
			case 19:
				switch (pin) {
				case 1:
					dev->irq = CMBVR41XX_INTB_IRQ;
					break;
				case 2:
					dev->irq = I8259_INTA_IRQ;
					break;
				case 3:
					dev->irq = CMBVR41XX_INTD_IRQ;
					break;
				case 4:
					dev->irq = CMBVR41XX_INTA_IRQ;
					break;
				}
				break;
			case 20:
				switch (pin) {
				case 1:
					dev->irq = CMBVR41XX_INTA_IRQ;
					break;
				case 2:
					dev->irq = CMBVR41XX_INTB_IRQ;
					break;
				case 3:
					dev->irq = I8259_INTA_IRQ;
					break;
				case 4:
					dev->irq = CMBVR41XX_INTD_IRQ;
					break;
				}
				break;
			case 31:	/* ALi M5237 USB Host Controller */
				dev->irq = USB_IRQ;
				break;
			}
			break;
		/*
		 * PCI Bus 1
		 */
		case 1:
			switch (slot) {
			case 1:
				dev->irq = CMBVR41XX_INTB_IRQ;
				break;
			case 5:
				switch (pin) {
				case 1:
					dev->irq = CMBVR41XX_INTD_IRQ;
					break;
				case 2:
					dev->irq = CMBVR41XX_INTA_IRQ;
					break;
				case 3:
					dev->irq = CMBVR41XX_INTB_IRQ;
					break;
				case 4:
					dev->irq = I8259_INTA_IRQ;
					break;
				}
				break;
			case 6:
				switch (pin) {
				case 1:
					dev->irq = CMBVR41XX_INTA_IRQ;
					break;
				case 2:
					dev->irq = CMBVR41XX_INTB_IRQ;
					break;
				case 3:
					dev->irq = I8259_INTA_IRQ;
					break;
				case 4:
					dev->irq = CMBVR41XX_INTD_IRQ;
					break;
				}
				break;
			case 7:
				switch (pin) {
				case 1:
					dev->irq = CMBVR41XX_INTD_IRQ;
					break;
				case 2:
					dev->irq = CMBVR41XX_INTA_IRQ;
					break;
				case 3:
					dev->irq = CMBVR41XX_INTB_IRQ;
					break;
				case 4:
					dev->irq = I8259_INTA_IRQ;
					break;
				}
				break;
			}
			break;
		}

		pci_write_config_byte(dev, PCI_INTERRUPT_LINE, dev->irq);
	}
}

unsigned int pcibios_assign_all_busses(void)
{
	return 0;
}
