/*
 * arch/mips/vr41xx/nec-cmbvr41xx/init.c
 *
 * PROM library initialisation code for NEC CMB-VR4122/VR4131 board.
 *
 * Author: Yoichi Yuasa <yyuasa@mvista.com, or source@mvista.com> and
 *         Jun Sun <jsun@mvista.com, or source@mvista.com>
 *
 * 2001-2003 (c) MontaVista, Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#include <linux/config.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/string.h>

#include <asm/bootinfo.h>

char arcs_cmdline[CL_SIZE];

const char *get_system_type(void)
{
	return "NEC CMB-VR4122/4131";
}

void __init bus_error_init(void)
{
}

/* Do basic initialization */
void __init prom_init(int argc, char **argv, unsigned long magic, int *prom_vec)
{
	int i;

	/*
	 * collect args and prepare cmd_line
	 */
	for (i = 1; i < argc; i++) {
		strcat(arcs_cmdline, argv[i]);
		if (i < (argc - 1))
			strcat(arcs_cmdline, " ");
	}

	mips_machgroup = MACH_GROUP_NEC_VR41XX;
	mips_machtype = MACH_NEC_CMBVR41XX;

	/* Add memory region, 128MB fixed */
	add_memory_region(0,  128 << 20, BOOT_MEM_RAM);
}

void __init prom_free_prom_memory (void)
{
}
