/*
 * arch/mips/vr41xx/nec-cmbvr4133/setup.c
 *
 * Setup for the NEC CMB-VR4133.
 *
 * Author: Yoichi Yuasa <yyuasa@mvista.com, or source@mvista.com> and
 *         Alex Sapkov <asapkov@ru.mvista.com>
 *
 * 2001-2004 (c) MontaVista, Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#include <linux/config.h>
#include <linux/init.h>
#include <linux/console.h>
#include <linux/ide.h>
#include <linux/ioport.h>

#include <asm/floppy.h>
#include <asm/keyboard.h>
#include <asm/pci_channel.h>
#include <asm/reboot.h>
#include <asm/time.h>
#include <asm/vr41xx/cmbvr4133.h>

#ifdef CONFIG_MTD
#include <linux/mtd/physmap.h>
static struct mtd_partition cmbvr4133_mtd_parts[] __initdata = {
	{
		.name =		"User FS",
		.size =		0x1be0000,
		.offset =	0,
		.mask_flags = 	0,
	}, {
		.name =		"PMON",
		.size =		0x140000,
		.offset =	MTDPART_OFS_APPEND,
		.mask_flags =	MTD_WRITEABLE,  /* force read-only */
	}, {
		.name =		"User FS2",
		.size =		MTDPART_SIZ_FULL,
		.offset =	MTDPART_OFS_APPEND,
		.mask_flags = 	0,
	}};
#define part_num (sizeof(cmbvr4133_mtd_parts)/sizeof(struct mtd_partition))
#endif

#ifdef CONFIG_BLK_DEV_INITRD
extern unsigned long initrd_start, initrd_end;
extern void * __rd_start, * __rd_end;
#endif

#ifdef CONFIG_PCI
static struct resource vr41xx_pci_io_resource = {
	"PCI I/O space",
	VR41XX_PCI_IO_START,
	VR41XX_PCI_IO_END,
	IORESOURCE_IO
};

static struct resource vr41xx_pci_mem_resource = {
	"PCI memory space",
	VR41XX_PCI_MEM_START,
	VR41XX_PCI_MEM_END,
	IORESOURCE_MEM
};

extern struct pci_ops vr41xx_pci_ops;

struct pci_channel mips_pci_channels[] = {
	{&vr41xx_pci_ops, &vr41xx_pci_io_resource, &vr41xx_pci_mem_resource, 0, 256},
	{NULL, NULL, NULL, 0, 0}
};

struct vr41xx_pci_address_space vr41xx_pci_mem1 = {
	VR41XX_PCI_MEM1_BASE,
	VR41XX_PCI_MEM1_MASK,
	IO_MEM1_RESOURCE_START
};

struct vr41xx_pci_address_space vr41xx_pci_mem2 = {
	VR41XX_PCI_MEM2_BASE,
	VR41XX_PCI_MEM2_MASK,
	IO_MEM2_RESOURCE_START
};

struct vr41xx_pci_address_space vr41xx_pci_io = {
	VR41XX_PCI_IO_BASE,
	VR41XX_PCI_IO_MASK,
	IO_PORT_RESOURCE_START
};

static struct vr41xx_pci_address_map pci_address_map = {
	&vr41xx_pci_mem1,
	&vr41xx_pci_mem2,
	&vr41xx_pci_io
};
#ifdef CONFIG_ROCKHOPPER
extern void ali_m5229_preinit(void);
extern void __init cmbvr4133_irq_init(void);
#endif

#endif

#ifdef CONFIG_PC_KEYB
extern struct kbd_ops cmbvr41xx_kbd_ops;
#endif

#ifdef CONFIG_BLK_DEV_FD
extern struct fd_ops std_fd_ops;
#endif

#if defined(CONFIG_BLK_DEV_IDE) || defined(CONFIG_BLK_DEV_IDE_MODULE)
extern struct ide_ops std_ide_ops;
#endif

#ifdef CONFIG_NEC_CANDY
static inline void candy_enable_irqs(void)
{
	volatile ushort *MMACINTREG = (volatile ushort *)0xaf000092;

	*MMACINTREG = 3;
}
#endif

void __init nec_cmbvr4133_setup(void)
{
	set_io_port_base(IO_PORT_BASE);
	ioport_resource.start = IO_PORT_RESOURCE_START;
	ioport_resource.end = IO_PORT_RESOURCE_END;
	iomem_resource.start = IO_MEM1_RESOURCE_START;
	iomem_resource.end = IO_MEM2_RESOURCE_END;

#ifdef CONFIG_BLK_DEV_INITRD
	ROOT_DEV = MKDEV(RAMDISK_MAJOR, 0);
	initrd_start = (unsigned long)&__rd_start;
	initrd_end = (unsigned long)&__rd_end;
#endif

	_machine_restart = vr41xx_restart;
	_machine_halt = vr41xx_halt;
	_machine_power_off = vr41xx_power_off;

	board_time_init = vr41xx_time_init;
	board_timer_setup = vr41xx_timer_setup;

#ifdef CONFIG_ROCKHOPPER
	board_irq_init = cmbvr4133_irq_init;
#else
	board_irq_init = NULL;
#endif

#ifdef CONFIG_FB
	conswitchp = &dummy_con;
#endif

#ifdef CONFIG_PC_KEYB
	kbd_ops = &cmbvr41xx_kbd_ops;
#endif

#ifdef CONFIG_BLK_DEV_FD
	fd_ops = &std_fd_ops;
#endif

#if defined(CONFIG_BLK_DEV_IDE) || defined(CONFIG_BLK_DEV_IDE_MODULE)
	ide_ops = &std_ide_ops;
#endif
	vr41xx_bcu_init();

	vr41xx_cmu_init(0);

	vr41xx_siu_init(SIU_RS232C, 0);
#ifdef CONFIG_KGDB
	vr41xx_dsiu_debug_init(BAUD_RATE_38400, DATA_8BIT, PARITY_NONE, STOP_1BIT);
#else
	vr41xx_dsiu_init();
#endif

#ifdef CONFIG_NEC_CANDY
	/* By default ETH0 & ETH1 interrupts are masked in the ICU's
	registers in 4133 so we have to enable them explicitly. Common
	ICU code from arch/mips/common/icu.c doesn't take care about that. */
	candy_enable_irqs();
#endif

#ifdef CONFIG_PCI
	vr41xx_pciu_init(&pci_address_map);
#ifdef CONFIG_ROCKHOPPER
	ali_m5229_preinit();
#endif
#endif

#ifdef CONFIG_MTD
	/* we use generic physmap mapping driver and we use partitions */
	physmap_configure(0x1C000000, 0x02000000, 4, NULL);
	physmap_set_partitions(cmbvr4133_mtd_parts, part_num);
#endif
}
