/*
 * arch/mips/vr41xx/nec-cmbvr4133/init.c
 *
 * PROM library initialisation code for NEC CMB-VR4133 board.
 *
 * Author: Yoichi Yuasa <yyuasa@mvista.com, or source@mvista.com> and
 *         Jun Sun <jsun@mvista.com, or source@mvista.com> and
 *         Alex Sapkov <asapkov@ru.mvista.com>
 *
 * 2001-2004 (c) MontaVista, Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#include <linux/config.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/string.h>

#include <asm/bootinfo.h>

#ifdef CONFIG_ROCKHOPPER
#include <asm/io.h>
#include <linux/pci.h>

#define PCICONFDREG	0xaf000c14
#define PCICONFAREG	0xaf000c18
#endif

char arcs_cmdline[CL_SIZE];

const char *get_system_type(void)
{
	return "NEC CMB-VR4133";
}

void __init bus_error_init(void)
{
}

#ifdef CONFIG_ROCKHOPPER
static void disable_pcnet()
{
	u32 data;

	/* Workaround for the bug in PMON on VR4133. PMON leaves
	AMD PCNet controller (on Rockhopper) initialized and running in
	bus master mode. We have do disable it before doing any
	further initialization. Or we get problems with PCI bus 2
	and random lockups and crashes.*/

	writel((2 << 16)		|
	       (PCI_DEVFN(1,0) << 8)	|
	       (0 & 0xfc)		|
               1UL,
	       PCICONFAREG);

	data = readl(PCICONFDREG);

	writel((2 << 16)		|
	       (PCI_DEVFN(1,0) << 8)	|
	       (4 & 0xfc)		|
               1UL,
	       PCICONFAREG);

	data = readl(PCICONFDREG);

	writel((2 << 16)		|
	       (PCI_DEVFN(1,0) << 8)	|
	       (4 & 0xfc)		|
               1UL,
	       PCICONFAREG);
	
	data &= ~4;

	writel(data, PCICONFDREG);
}
#endif

/* Do basic initialization */
void __init prom_init(int argc, char **argv, unsigned long magic, int *prom_vec)
{
	int i;

#ifdef CONFIG_ROCKHOPPER
	disable_pcnet();
#endif

	/*
	 * collect args and prepare cmd_line
	 */

	for (i = 1; i < argc; i++) {
		strcat(arcs_cmdline, argv[i]);
		if (i < (argc - 1))
			strcat(arcs_cmdline, " ");
	}

	if (argc == 1) 
		strcpy(arcs_cmdline, "console=ttyS0,38400 ip=bootp");

	mips_machgroup = MACH_GROUP_NEC_VR41XX;
	mips_machtype = MACH_NEC_CMBVR4133;

	/* Add memory region, 128MB fixed */
	add_memory_region(0,  128 << 20, BOOT_MEM_RAM);
}

void __init prom_free_prom_memory (void)
{
}
