/*
 * arch/mips/vr41xx/nec-cmbvr4133/candy_setup.c
 *
 * NEC Candy ether driver board-specific setup routine.
 *
 * Author: Alex Sapkov <asapkov@ru.mvisa.com> or <source@mvista.com>
 *
 * 2004 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/init.h>
#include <asm/io.h>
#include <asm/vr41xx/cmbvr4133.h>

#define VR4133_ETHERNET0_BASE		KSEG1ADDR(0x0F001400)
#define VR4133_ETHERNET1_BASE		KSEG1ADDR(0x0F001700)

#define CANDY_LSA1 0x0058
#define CANDY_LSA2 0x0054

static struct {
        uint    irq;
        ulong   base_addr;
        ulong   pmd_addr;
        u_char  mac_addr[6];
	void 	(*clk_supply)(void);
        int     mac_configured;
} candy_boot_params[] = {
	{MAC_IRQ, VR4133_ETHERNET0_BASE, 0, 
         {0x00, 0x00, 0x4c, 0x80, 0xea, 0x88}, vr4133_clock_ether0_supply, 0},
	{MAC_IRQ, VR4133_ETHERNET1_BASE, 0, 
	 {0x00, 0x00, 0x4c, 0x80, 0xea, 0x89}, vr4133_clock_ether1_supply, 0}
};

#define MAX_NUM_DEVS (sizeof(candy_boot_params)/sizeof(candy_boot_params[0]))

int nec_candy_get_boot_params(uint * irq,
                              ulong * base_addr,
                              ulong * pmd_addr,
                              u_char * mac_addr)
{
	static int index=0;
	int i;
	/* the address to read MAC addr from flash */
	unsigned char *mac_flash = (unsigned char *)0xbdbffe00;

	if (index == MAX_NUM_DEVS) 
	        return -1;

	*irq = candy_boot_params[index].irq;
	*base_addr = candy_boot_params[index].base_addr;
	*pmd_addr = candy_boot_params[index].pmd_addr;

	if (!candy_boot_params[index].mac_configured) {
		/* read MAC addr from Flash */
		if(index) mac_flash += 6; /* it's the 2nd one */
		for(i = 0; i < 6; i++) {
			mac_addr[i] = mac_flash[i];
		}
	} else {
		for (i = 0; i < 6; i++) 
			mac_addr[i] = candy_boot_params[index].mac_addr[i];
	}

	index ++;
	return 0;
}

EXPORT_SYMBOL(nec_candy_get_boot_params);


/*
 * kernel boot parameters
 * format: "nec_candy_mac=xx,xx,xx,xx,xx,xx [nec_candy_mac=xx,xx,xx,xx,xx,xx]"
 */
static int __init
nec_candy_boot_setup(char *str)
{
	int ints[10];
	int i;
	static int index=0;

	str = get_options(str, ARRAY_SIZE(ints), ints);

	if (ints[0] != 6) return 0;
	
	if (index == MAX_NUM_DEVS) return 1;	/* ignore params */

	for (i=0; i< 6; i++) 
		candy_boot_params[index].mac_addr[i] = (u_char)ints[i+1];
	candy_boot_params[index].mac_configured = 1;
	index++;
	return 1;
}

__setup("nec_candy_mac=", nec_candy_boot_setup);

