/*
 * arch/mips/vr41xx/common/vr4133.c
 *
 * NEC VR4133 specific routines.
 *
 * Author: Alex Sapkov <asapkov@ru.mvista.com> or <source@mvista.com>
 *
 * 2001-2004 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#include <linux/init.h>
#include <linux/types.h>

#include <asm/cpu.h>
#include <asm/io.h>

#define VR4133_CMUCLKMSK2	KSEG1ADDR(0x0f000064)

#define VR4133_CMU_CEU 		0x0001
#define VR4133_CMU_MSKMAC0	0x0002
#define VR4133_CMU_MSKMAC1	0x0004

/* Clock Mask Unit primitives */

void vr4133_clock_ceu_supply(void)
{
	u16 cmuclkmsk2;

	cmuclkmsk2 = readw(VR4133_CMUCLKMSK2) | VR4133_CMU_CEU;
	writew(cmuclkmsk2, VR4133_CMUCLKMSK2);
}

void vr4133_clock_ceu_mask(void)
{
	u16 cmuclkmsk2;

	cmuclkmsk2 = readw(VR4133_CMUCLKMSK2) & ~VR4133_CMU_CEU;
	writew(cmuclkmsk2, VR4133_CMUCLKMSK2);
}

void vr4133_clock_ether0_supply(void)
{
	u16 cmuclkmsk2;

	cmuclkmsk2 = readw(VR4133_CMUCLKMSK2) | VR4133_CMU_MSKMAC0;
	writew(cmuclkmsk2, VR4133_CMUCLKMSK2);
}

void vr4133_clock_ether0_mask(void)
{
	u16 cmuclkmsk2;

	cmuclkmsk2 = readw(VR4133_CMUCLKMSK2) & ~VR4133_CMU_MSKMAC0;
	writew(cmuclkmsk2, VR4133_CMUCLKMSK2);
}

void vr4133_clock_ether1_supply(void)
{
	u16 cmuclkmsk2;

	cmuclkmsk2 = readw(VR4133_CMUCLKMSK2) | VR4133_CMU_MSKMAC1;
	writew(cmuclkmsk2, VR4133_CMUCLKMSK2);
}

void vr4133_clock_ether1_mask(void)
{
	u16 cmuclkmsk2;

	cmuclkmsk2 = readw(VR4133_CMUCLKMSK2) & ~VR4133_CMU_MSKMAC1;
	writew(cmuclkmsk2, VR4133_CMUCLKMSK2);
}


