/*
 * arch/mips/vr4181a/common/time.c
 *
 * Basic timer routines for the NEC VR4181A.
 *
 * Author: Yoichi Yuasa <yyuasa@mvista.com, or source@mvista.com>
 *
 * 2003 (c) MontaVista, Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#include <linux/init.h>
#include <linux/interrupt.h>
#include <linux/irq.h>
#include <linux/types.h>

#include <asm/mipsregs.h>
#include <asm/param.h>
#include <asm/time.h>

#define MIPS_COUNTER_IRQ	7

void __init
vr4181a_timer_setup(struct irqaction *irq)
{
	u32 count;

	setup_irq(MIPS_COUNTER_IRQ, irq);

	count = read_c0_count();
	write_c0_compare(count + (mips_counter_frequency / HZ));
}
