/*
 * arch/mips/vr4181a/common/reboot.c
 *
 * Depending on NEC VR4181A of reboot system call.
 *
 * Author: Yoichi Yuasa <yyuasa@mvista.com, or source@mvista.com>
 *
 * 2003 (c) MontaVista, Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#include <linux/kernel.h>

#include <asm/system.h>
#include <asm/vr4181a/vr4181a.h>

void
vr4181a_restart(char *command)
{
	local_irq_disable();
	vr4181a_soft_reset();
	while (1) ;
}

void
vr4181a_halt(void)
{
	local_irq_disable();
	while (1) ;
}

void
vr4181a_power_off(void)
{
	local_irq_disable();
	while (1) ;
}
