/*
 * arch/mips/vr4181a/common/prom.c
 *
 * Initialisation code for the NEC VR4181A.
 *
 * Author: Yoichi Yuasa <yyuasa@mvista.com, or source@mvista.com>
 *
 * 2002-2003 (c) MontaVista, Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#include <linux/config.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/string.h>

#include <asm/bootinfo.h>
#include <asm/vr4181a/vr4181a.h>

#ifdef CONFIG_EMBEDDED_RAMDISK
char arcs_cmdline[CL_SIZE] =
    "console=ttyS0,38400 ip=any root=/dev/ram rw smc91111=2,0x23f0000 ether=75,0xe340,eth0 ether=76,0xe240,eth1";
#else
char arcs_cmdline[CL_SIZE] =
    "console=ttyS0,38400 ip=any root=/dev/nfs rw smc91111=2,0x23f0000 ether=75,0xe340,eth0 ether=76,0xe240,eth1";
#endif

void __init
prom_init(int argc, char **argv, char **envp, int *prom_vec)
{
	int i;

	/*
	 * collect args and prepare cmd_line
	 */
	for (i = 1; i < argc; i++) {
		strcat(arcs_cmdline, argv[i]);
		if (i < (argc - 1))
			strcat(arcs_cmdline, " ");
	}

	mips_machgroup = MACH_GROUP_NEC_VR4181A;
	mips_machtype =
	    vr4181a_platform_init(argc, argv, envp, prom_vec, arcs_cmdline);
}

void __init
prom_free_prom_memory(void)
{
}
