/*
 * arch/mips/vr4181a/common/pmu.c
 *
 * Power Management Unit routines for the NEC VR4181A.
 *
 * Author: Yoichi Yuasa <yyuasa@mvista.com, or source@mvista.com>
 *
 * 2002-2003 (c) MontaVista, Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#include <linux/init.h>
#include <linux/types.h>

#include <asm/vr4181a/vr4181a.h>

#define PMUINTREG	0xb0a0
#define GPWAKEUP	0x1000
#define RTCINT_WAKEUP	0x0200
#define NMI		0x0100
#define TIMEOUTRST	0x0020
#define RTCRST		0x0010
#define RTCSW		0x0008
#define WDTRST		0x0004
#define NMIR		0x0002
#define POWERSWINTR	0x0001
#define PMUCNTREG	0xb0a2
#define HALTIMERRST	0x0004
#define PMUCNT2REG	0xb0a6
#define SOFTRSTSW	0x0010
#define PMUWAITREG	0xb0a8
#define PMUDIVREG	0xb0ac
#define DIV3		0x0003
#define DIV2		0x0002
#define DIVMODE	0x0000

void
vr4181a_reset_haltimer(void)
{
	if (!(vr4181a_readw(PMUCNTREG) & HALTIMERRST)) {
		vr4181a_writew(HALTIMERRST, PMUCNTREG);
		vr4181a_write_fixed;
	}
}

void
vr4181a_soft_reset(void)
{
	vr4181a_writew(SOFTRSTSW, PMUCNT2REG);
	vr4181a_write_fixed;
}

void
vr4181a_wait(void)
{
#if 0
	asm volatile (".set\tvr4100\n\t"
		      "standby\n\t"
		      "nop\n\t" "nop\n\t" "nop\n\t" ".set\tmips0\n");
#endif
}

void
vr4181a_chage_divide(int mode, int action)
{
	u16 div;

	switch (mode) {
	case DIVIDE_MODE2:
		div = 0x0002;
		break;
	case DIVIDE_MODE3:
		div = 0x0003;
		break;
	case DIVIDE_DEFAULT:
	default:
		div = 0;
		break;
	}

	vr4181a_writew(div, PMUDIVREG);
	vr4181a_write_fixed;

	if (action == HIBERNATE) ;
	else
		vr4181a_soft_reset();

}
