/*
 * arch/mips/vr4181a/common/pci_fixups.c
 *
 * The NEC VR4181A specific PCI fixups.
 *
 * Author: Yoichi Yuasa <yyuasa@mvista.com, or source@mvista.com>
 *
 * 2002-2003 (c) MontaVista, Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#include <linux/init.h>
#include <linux/pci.h>

#include <asm/vr4181a/vr4181a.h>

void __init
pcibios_fixup_resources(struct pci_dev *dev)
{
}

void __init
pcibios_fixup(void)
{
}

void __init
pcibios_fixup_irqs(void)
{
	struct pci_dev *dev;
	u8 slot;

	pci_for_each_dev(dev) {
		slot = PCI_SLOT(dev->devfn);
		dev->irq = 0;

		switch (slot) {
		case 29:
			dev->irq = AC97U_IRQ;
			break;
		case 30:
			dev->irq = USBFU_IRQ;
			break;
		case 31:
			dev->irq = USBHU_IRQ;
			break;
		}

		pci_write_config_byte(dev, PCI_INTERRUPT_LINE, dev->irq);
	}
}

unsigned int
pcibios_assign_all_busses(void)
{
	return 0;
}
