/*
 * arch/mips/vr4181a/common/int-handler.S
 *
 * Interrupt dispatcher for the NEC VR4181A.
 *
 * Author: Yoichi Yuasa <yyuasa@mvista.com, or source@mvista.com>
 *
 * 2002-2003 (c) MontaVista, Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#include <asm/asm.h>
#include <asm/regdef.h>
#include <asm/mipsregs.h>
#include <asm/stackframe.h>

		.text
		.set	noreorder

		.align	5
		NESTED(vr4181a_handle_interrupt, PT_SIZE, ra)
		.set	noat
		SAVE_ALL
		CLI
		.set	at
		.set	noreorder

		/*
		 * Get the pending interrupts
		 */
		mfc0	t0, CP0_CAUSE
		mfc0	t1, CP0_STATUS
		andi	t0, 0xff00		# pick up IP0-7
		and	t0, t0, t1

		andi	t1, t0, CAUSEF_IP7	# timer interrupt
		beqz	t1, 1f
		li	a0, 7
		jal	ll_timer_interrupt
		move	a1, sp
		j	ret_from_irq

1:
		andi	t1, t0, CAUSEF_IP2	# Int0
		bnez	t1, 2f
		li	a0, 0

		andi	t1, t0, CAUSEF_IP3	# Int1
		bnez	t1, 2f
		li	a0, 1

		andi	t1, t0, CAUSEF_IP4	# Int2
		bnez	t1, 2f
		li	a0, 2

		andi	t1, t0, CAUSEF_IP5	# Int3
		bnez	t1, 2f
		li	a0, 3

		andi	t1, t0, CAUSEF_IP6	# Int4
		beqz	t1, 3f
		li	a0, 4
		jal	int4_irqdispatch
		move	a1, sp
		j	ret_from_irq
		nop

2:
		jal	int0_irqdispatch
		move	a1, sp
		j	ret_from_irq
		nop

3:
		andi	t1, t0, CAUSEF_IP0	# Soft Int0
		bnez	t1, handle_it
		li	a0, 0

		andi	t1, t0, CAUSEF_IP1	# Soft Int1
		bnez	t1, handle_it
		li	a0, 1
		j	spurious_interrupt
		nop

handle_it:
		jal	do_IRQ
		move	a1, sp
		j	ret_from_irq
		END(vr4181a_handle_interrupt)
