/*
 * linux/arch/mips/tx4938/toshiba_rbtx4938/prom.c
 *
 * rbtx4938 specific prom routines
 *
 * Author: source@mvista.com
 *
 * Copyright 2001-2002 MontaVista Software Inc.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation 
 *
 * 2003 (c) MontaVista Software, Inc. This file is licensed under the
 * terms of the GNU General Public License version 2. This program is
 * licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */

#include <linux/config.h>
#include <linux/init.h>
#include <linux/mm.h>
#include <linux/sched.h>
#include <linux/bootmem.h>

#include <asm/addrspace.h>
#include <asm/bootinfo.h>
#include <asm/tx4938/tx4938.h>
#include <asm/tx4938/prom.h>

#ifndef COMMAND_LINE_SIZE
#define COMMAND_LINE_SIZE CL_SIZE
#endif

static int *_prom_envp;

/*
 * YAMON (32-bit PROM) pass arguments and environment as 32-bit pointer.
 * This macro take care of sign extension, if running in 64-bit mode.
 */
#define prom_envp(index) ((char *)(((int *)(int)_prom_envp)[(index)]))

char *prom_getenv(char *envname)
{
	/*
	 * Return a pointer to the given environment variable.
	 * In 64-bit mode: we're using 64-bit pointers, but all pointers 
	 * in the PROM structures are only 32-bit, so we need some 
	 * workarounds, if we are running in 64-bit mode.
	 */
	int i, index=0;

	i = strlen(envname);

	while(prom_envp(index)) {
		if(strncmp(envname, prom_envp(index), i) == 0) {
			return(prom_envp(index+1));
		}
		index += 2;
	}

	return(NULL);
}

char arcs_cmdline[COMMAND_LINE_SIZE] = "console=ttyS0,38400 ip=any root=/dev/nfs rw";

void __init
prom_init_cmdline(int argc, char **argv)
{
	int i;			/* Always ignore the "-c" at argv[0] */

	/* ignore all built-in args if any f/w args given */
	if (argc > 1) {
		*arcs_cmdline = '\0';
	}

	for (i = 1; i < argc; i++) {
		if (i != 1) {
			strcat(arcs_cmdline, " ");
		}
		strcat(arcs_cmdline, argv[i]);
	}
}

void __init
prom_init(int argc, char **argv, char **envp, int *pvec)
{
	extern int tx4938_get_mem_size(void);
	int msize;

	_prom_envp = (int *)envp;

#ifndef CONFIG_TX4938_NAND_BOOT
	prom_init_cmdline(argc, argv);
#endif

	mips_machgroup = MACH_GROUP_TOSHIBA;
	mips_machtype = MACH_TOSHIBA_RBTX4938;

	msize = tx4938_get_mem_size();
	add_memory_region(0, msize << 20, BOOT_MEM_RAM);

	return;
}

void __init
prom_free_prom_memory(void)
{
	return;
}

void __init
prom_fixup_mem_map(unsigned long start, unsigned long end)
{
	return;
}

const char *get_system_type(void)
{
	return "Toshiba RBTX4938";
}
