/*
 * linux/arch/mips/tx4938/common/nandbootvector.S
 *
 * Setup interrupt vectors to NAND boot dependent of RBTX4938.
 *
 * Author: source@mvista.com
 *
 * Copyright 2001-2002 MontaVista Software Inc.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation
 *
 * 2003 (c) MontaVista Software, Inc. This file is licensed under the
 * terms of the GNU General Public License version 2. This program is
 * licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */

#include <linux/config.h>
#include <linux/init.h>

#include <asm/asm.h>
#include <asm/regdef.h>
#include <asm/mipsregs.h>
#include <asm/stackframe.h>
#include <asm/tx4938/tx4938.h>
#include <asm/tx4938/rbtx4938.h>

	.section ".init", "ax"

	.set noreorder
	.set noat
	.set mips0

	LEAF(tx4938_nandboot_reset_vector)
#ifdef CONFIG_CPU_LITTLE_ENDIAN
	la      k0, TX4938_EBUSC_REG            # setup EBUS1
	li      k1, 0x01c00000                  # EBUS1 default value
	sw      k1, 0x4(k0)                     # set EBUS1 register
	li      k1, 0x00103610                  # EBUS1 default value
	sw      k1, 0x0(k0)                     # set EBUS1 register
	li      k1, 0x00103618                  # enable EBUS1 ME 
	sw      k1, 0x0(k0)                     # set EBUS1 register

	li      k1, 0x017f0000                  # EBUS2 default value
	sw      k1, 0x14(k0)                    # set EBUS2 register
	li      k1, 0x0033f010                  # EBUS2 default value
	sw      k1, 0x10(k0)                    # set EBUS2 register
	li      k1, 0x0033f018                  # enabe EBUS2 ME 
	sw      k1, 0x10(k0)                    # set EBUS2 register
#else
	la      k0, TX4938_EBUSC_REG            # setup EBUS1
	li      k1, 0x01c00000                  # EBUS1 default value
	sw      k1, 0x0(k0)                     # set EBUS1 register
	li      k1, 0x00103610                  # EBUS1 default value
	sw      k1, 0x4(k0)                     # set EBUS1 register
	li      k1, 0x00103618                  # EBUS1 ME enable 
	sw      k1, 0x4(k0)                     # set EBUS1 register

	li      k1, 0x017f0000                  # EBUS2 default value
	sw      k1, 0x10(k0)                    # set EBUS2 register
	li      k1, 0x0033f010                  # EBUS2 default value
	sw      k1, 0x14(k0)                    # set EBUS2 register
	li      k1, 0x0033f018                  # enable EBUS2 ME 
	sw      k1, 0x14(k0)                    # set EBUS2 register
#endif

	li      k1, 0xffff                      # wait
1:	addiu   k1, k1, -1
	bne     k1, 0, 1b
	nop

/*
 * Before jump to kernel_entry,
 * RBTX4938's LEDs display as " x x x x x x x x ".   x : turn off
 */
	li      k1, 0xff
	la      k0, RBTX4938_LED_ADDR           # unset LED bit
	sb      k1, 0(k0)                       # store
	nop
	j       kernel_entry
	nop
	END(tx4938_nandboot_reset_vector)

	.org 0x0200
	LEAF(tx4938_nandboot_utlb_vector)
/*
 * RBTX4938's LEDs display as " x x x x x x x * ".   x : turn off , * : turn on
 */
	li      k1, 0xfe
	la      k0, RBTX4938_LED_ADDR           # set LED[USR1:0]=OFF:ON
	sb      k1, 0(k0)                       # store
	nop
tx4938_nandboot_utlb_vector_loop:
	j       tx4938_nandboot_utlb_vector_loop
	nop
	END(tx4938_nandboot_utlb_vector)

	.org 0x0280
	LEAF(tx4938_nandboot_xtlb_vector)
/*
 * RBTX4938's LEDs display as " x x x x x x * x ".   x : turn off , * : turn on
 */
	li      k1, 0xfd
	la      k0, RBTX4938_LED_ADDR           # set LED[USR1:0]=ON:OFF
	sb      k1, 0(k0)                       # store
	nop
tx4938_nandboot_xtlb_vector_loop:
	j       tx4938_nandboot_xtlb_vector_loop
	nop
	END(tx4938_nandboot_xtlb_vector)

	.org 0x0380
	LEAF(tx4938_nandboot_general_exception_vector)
/*
 * RBTX4938's LEDs display as " y y y y y y * * ".
 * y y y y y y : ExcCode bits[6..2] of Cause register, * : turn on     
 */
	mfc0    k1, $13                         # CP0.Cause(#13)
	nop
	andi    k1, 0x7c                        # Mask Cause.IP[6:2]
	la      k0, RBTX4938_LED_ADDR
	xori    k1, k1, 0xff
	andi    k1, 0xfc                        # set LED[USR1:0]=ON:ON
	sb      k1, 0(k0)                       # store
	nop
tx4938_nandboot_general_exception_vector_loop:
	j       tx4938_nandboot_general_exception_vector_loop
	nop
	END(tx4938_nandboot_general_exception_vector)

	.set reorder
	.set at

