/*
 * Copyright 2001 MontaVista Software Inc.
 *
 * Author: source@mvista.com
 *
 * RTC routines for toshiba_rbtx4927
 *
 * Copyright (C) 2000-2001 Toshiba Corporation 
 *
 * 2001-2003 (c) MontaVista Software, Inc. This file is licensed under the
 * terms of the GNU General Public License version 2. This program is
 * licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#include <asm/mc146818rtc.h>
#include <asm/tx4927/toshiba_rbtx4927.h>

static unsigned char toshiba_rbtx4927_rtc_read_data(unsigned long addr)
{
        return (*(volatile u8*)(RBTX4927_RTC_BASE+addr));
}

static void toshiba_rbtx4927_rtc_write_data(unsigned char data, unsigned long addr)
{
	((*(volatile u8*)(RBTX4927_RTC_BASE+addr))=(data));
}

static int toshiba_rbtx4927_rtc_bcd_mode(void)
{
        return 1;
}

struct rtc_ops toshiba_rbtx4927_rtc_ops = {
        &toshiba_rbtx4927_rtc_read_data,
        &toshiba_rbtx4927_rtc_write_data,
        &toshiba_rbtx4927_rtc_bcd_mode
};
