/*
 * linux/arch/mips/tx4925/toshiba_rbtx4925/setup.c
 *
 * Toshiba rbtx4925 specific setup
 *
 * Author: MontaVista Software, Inc. source@mvista.com
 *
 * Copyright 2001-2002 MontaVista Software Inc.
 *
 * Copyright (C) 1996, 1997, 2001  Ralf Baechle
 * Copyright (C) 2000 RidgeRun, Inc.
 * Author: RidgeRun, Inc.
 *   glonnon@ridgerun.com, skranz@ridgerun.com, stevej@ridgerun.com
 *
 * Copyright 2001 MontaVista Software Inc.
 * Author: jsun@mvista.com or jsun@junsun.net
 *
 * Copyright 2002 MontaVista Software Inc.
 * Author: Michael Pruznick, michael_pruznick@mvista.com
 *
 * Copyright (C) 2000-2001 Toshiba Corporation 
 *
 * 2003 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */

#include <linux/config.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/mm.h>
#include <linux/swap.h>
#include <linux/ioport.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/pci.h>
#include <linux/timex.h>
#include <asm/bootinfo.h>
#include <asm/page.h>
#include <asm/bootinfo.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/pci.h>
#include <asm/processor.h>
#include <asm/ptrace.h>
#include <asm/reboot.h>
#include <asm/cpu.h>
#include <asm/time.h>
#ifdef CONFIG_TOSHIBA_FPCIB0
#include <asm/smsc_fdc37m81x.h>
#endif
#include <linux/version.h>
#include <linux/bootmem.h>
#include <linux/blk.h>
#include <linux/console.h>
#include <asm/tx4925/tx4925.h>
#include <asm/tx4925/tx4925_rtc.h>
#include <asm/tx4925/toshiba_rbtx4925.h>
#ifdef CONFIG_PCI
#include <asm/tx4925/tx4925_pci.h>
#include <linux/types.h>
#include <linux/pci.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <asm/pci_channel.h>
#endif
#ifdef CONFIG_PC_KEYB
#include <asm/keyboard.h>
#endif
#ifdef CONFIG_IDE
#include <linux/ide.h>
extern struct ide_ops rbtx4925_ide_ops;
extern struct ide_ops std_ide_ops;
#endif

#undef TOSHIBA_RBTX4925_SETUP_DEBUG

#ifdef TOSHIBA_RBTX4925_SETUP_DEBUG
#define TOSHIBA_RBTX4925_SETUP_NONE        0x00000000

#define TOSHIBA_RBTX4925_SETUP_INFO        ( 1 <<  0 )
#define TOSHIBA_RBTX4925_SETUP_WARN        ( 1 <<  1 )
#define TOSHIBA_RBTX4925_SETUP_EROR        ( 1 <<  2 )

#define TOSHIBA_RBTX4925_SETUP_EFWFU       ( 1 <<  3 )
#define TOSHIBA_RBTX4925_SETUP_SETUP       ( 1 <<  4 )
#define TOSHIBA_RBTX4925_SETUP_TIME_INIT   ( 1 <<  5 )
#define TOSHIBA_RBTX4925_SETUP_TIMER_SETUP ( 1 <<  6 )
#define TOSHIBA_RBTX4925_SETUP_PCIBIOS     ( 1 <<  7 )
#define TOSHIBA_RBTX4925_SETUP_PCI1        ( 1 <<  8 )
#define TOSHIBA_RBTX4925_SETUP_PCI2        ( 1 <<  9 )
#define TOSHIBA_RBTX4925_SETUP_PCI66       ( 1 << 10 )

#define TOSHIBA_RBTX4925_SETUP_ALL         0xffffffff
#endif

#ifdef TOSHIBA_RBTX4925_SETUP_DEBUG
static const u32 toshiba_rbtx4925_setup_debug_flag =
    (TOSHIBA_RBTX4925_SETUP_NONE | TOSHIBA_RBTX4925_SETUP_INFO |
     TOSHIBA_RBTX4925_SETUP_WARN | TOSHIBA_RBTX4925_SETUP_EROR |
     TOSHIBA_RBTX4925_SETUP_EFWFU | TOSHIBA_RBTX4925_SETUP_SETUP |
     TOSHIBA_RBTX4925_SETUP_TIME_INIT | TOSHIBA_RBTX4925_SETUP_TIMER_SETUP
     | TOSHIBA_RBTX4925_SETUP_PCIBIOS | TOSHIBA_RBTX4925_SETUP_PCI1 |
     TOSHIBA_RBTX4925_SETUP_PCI2 | TOSHIBA_RBTX4925_SETUP_PCI66);
#endif

#ifdef TOSHIBA_RBTX4925_SETUP_DEBUG
#define TOSHIBA_RBTX4925_SETUP_DPRINTK(flag,str...) \
        if ( (toshiba_rbtx4925_setup_debug_flag) & (flag) ) \
        { \
           char tmp[100]; \
           sprintf( tmp, str ); \
           printk( "%s(%s:%u)::%s", __FUNCTION__, __FILE__, __LINE__, tmp ); \
        }
#else
#define TOSHIBA_RBTX4925_SETUP_DPRINTK(flag,str...)
#endif

/* These functions are used for rebooting or halting the machine*/
extern void toshiba_rbtx4925_restart(char *command);
extern void toshiba_rbtx4925_halt(void);
extern void toshiba_rbtx4925_power_off(void);

extern void gt64120_time_init(void);
extern void toshiba_rbtx4925_irq_setup(void);

#ifdef CONFIG_PCI
#undef TX4925_SUPPORT_COMMAND_IO
unsigned long mips_pci_io_base;	/* calculated */
unsigned long mips_pci_io_size = TX4925_PCIIO_SIZE;
unsigned long mips_pci_mem_base;	/* calculated */
unsigned long mips_pci_mem_size = TX4925_PCIMEM_SIZE;
/* for legacy I/O, PCI I/O PCI Bus address must be 0 */
unsigned long mips_memory_upper;
unsigned long tx4925_memory_upper_max = 0;
static int tx4925_ccfg_toeon = 1;
static int tx4925_pcic_trdyto = 0;	/* default: disabled */
static int tx4925_pcic_retryto = 0;	/* default: disabled */
unsigned long tx4925_ce_base[8];
void tx4925_pci_setup(void);
void tx4925_reset_pci_pcic(void);

#ifdef CONFIG_TOSHIBA_RBTX4925_MPLEX_PCMCIA
/*
 * toshiba_rbtx4925_ebusc_resetup: force reset EBUSC[3:7] for PCMCIA.
 */
static void
toshiba_rbtx4925_ebusc_resetup(void)
{
	int ch;
	for (ch = 3; ch < 8; ch++) {
		tx4925_ebuscptr->ch[ch].cr = 0;
		tx4925_ebuscptr->ch[ch].bar = 0;
	}
}
#endif

static void
toshiba_rbtx4925_mplex_3124_setup(void)
{
	vu32 pcfg;
	vu8 piosel;

	/* setup for multiplex pin PIO[31:24] */
	pcfg = TX4925_RD(TX4925_REG(TX4925_CONFIG_PCFG));
	pcfg &=
	    ~(TX4925_CONFIG_PCFG_SELCHI | TX4925_CONFIG_PCFG_SELCARD |
	      TX4925_CONFIG_PCFG_SELCE);

	piosel = RBTX4925_IOC_REG(PIOSEL);

#ifdef CONFIG_TOSHIBA_RBTX4925_MPLEX_PIO31_24
	pcfg |= 0;
	piosel |= RBTX4925_PIOSEL_NOPCMCIA;
#endif
#ifdef CONFIG_TOSHIBA_RBTX4925_MPLEX_CE
	pcfg |= (TX4925_CONFIG_PCFG_SELCHI | TX4925_CONFIG_PCFG_SELCE);
	piosel |= RBTX4925_PIOSEL_NOPCMCIA;
#endif
#ifdef CONFIG_TOSHIBA_RBTX4925_MPLEX_PCMCIA
	toshiba_rbtx4925_ebusc_resetup();
	pcfg |= TX4925_CONFIG_PCFG_SELCARD;
	piosel &= ~RBTX4925_PIOSEL_NOPCMCIA;
#endif
	TX4925_WR(TX4925_REG(TX4925_CONFIG_PCFG), pcfg);
	RBTX4925_IOC_REG(PIOSEL) = piosel;
}

static void
toshiba_rbtx4925_mplex_1712_setup(void)
{
	vu32 pcfg;
	vu8 piosel;

	/* setup for multiplex pin PIO[17:12] */
	pcfg = TX4925_RD(TX4925_REG(TX4925_CONFIG_PCFG));
	pcfg &= ~(TX4925_PCFG_SELSIOC(1) |
		  TX4925_PCFG_SELSIO(1) |
		  TX4925_CONFIG_PCFG_SELACLC | TX4925_CONFIG_PCFG_SELNAND);

	piosel = RBTX4925_IOC_REG(PIOSEL);
	if (piosel & RBTX4925_PIOSEL_NOSMART) {
		/*
		 * DipSW indicate smartmedia does not use
		 */
		piosel |= (RBTX4925_PIOSEL_NOACLINK | RBTX4925_PIOSEL_NOSMART);
		piosel &= ~RBTX4925_PIOSEL_SIO1;

#ifdef CONFIG_TOSHIBA_RBTX4925_MPLEX_SIO1
		pcfg |= (TX4925_PCFG_SELSIOC(1) | TX4925_PCFG_SELSIO(1));
		piosel |= RBTX4925_PIOSEL_SIO1;
#endif
#ifdef CONFIG_TOSHIBA_RBTX4925_MPLEX_NAND
		pcfg |= TX4925_CONFIG_PCFG_SELNAND;
		piosel &= ~RBTX4925_PIOSEL_NOSMART;
#endif
#ifdef CONFIG_TOSHIBA_RBTX4925_MPLEX_ACLC
		pcfg |= TX4925_CONFIG_PCFG_SELACLC;
		piosel &= ~RBTX4925_PIOSEL_NOACLINK;
#endif
	} else {
		/*
		 * DipSW indicate smartmedia use
		 */
#if ( defined( CONFIG_TOSHIBA_RBTX4925_MPLEX_SIO1 ) |   \
		      defined( CONFIG_TOSHIBA_RBTX4925_MPLEX_ACLC ) )
		printk
		    ("DipSW detected. force setup PCFG and PIOSEL to NAND!!\n");
#endif
		piosel |= RBTX4925_PIOSEL_NOACLINK;
		piosel &= ~(RBTX4925_PIOSEL_SIO1 | RBTX4925_PIOSEL_NOSMART);
		pcfg |= TX4925_CONFIG_PCFG_SELNAND;
	}

	TX4925_WR(TX4925_REG(TX4925_CONFIG_PCFG), pcfg);
	RBTX4925_IOC_REG(PIOSEL) = piosel;

}

static void
toshiba_rbtx4925_mplex_setup(void)
{
	toshiba_rbtx4925_mplex_3124_setup();
	toshiba_rbtx4925_mplex_1712_setup();
}

void
tx4925_dump_pcic_settings(void)
{
	printk("tx4925 pcic settings:");
	{
		int i;
		unsigned long *preg = (unsigned long *) tx4925_pcicptr;
		for (i = 0; i < sizeof (struct tx4925_pcic_reg); i += 4) {
			if (i % 32 == 0)
				printk("\n%04x:", i);
			if (preg == &tx4925_pcicptr->g2pintack
			    || preg == &tx4925_pcicptr->g2pspc) {
				printk(" XXXXXXXX");
				preg++;
				continue;
			}
			printk(" %08lx", *preg++);
			if (preg == &tx4925_pcicptr->g2pcfgadrs)
				break;
		}
		printk("\n");
	}
}

static void
tx4925_pcierr_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
	extern void tx4925_dump_pcic_settings(void);

#ifdef CONFIG_IDE
	/* ignore MasterAbort for ide probing... */
	if (irq == TX4925_IRQ_IRC_PCIERR &&
	    ((tx4925_pcicptr->pcistatus >> 16) & 0xf900) ==
	    PCI_STATUS_REC_MASTER_ABORT) {
		tx4925_pcicptr->pcistatus =
		    (tx4925_pcicptr->
		     pcistatus & 0x0000ffff) | (PCI_STATUS_REC_MASTER_ABORT
						<< 16);

		return;
	}
#endif

	printk("PCI error interrupt (irq 0x%x).\n", irq);
	printk("pcistat:%04x, g2pstatus:%08lx, pcicstatus:%08lx\n",
	       (unsigned short) (tx4925_pcicptr->pcistatus >> 16),
	       tx4925_pcicptr->g2pstatus, tx4925_pcicptr->pcicstatus);
	printk("ccfg:%08lx\n", (unsigned long) tx4925_ccfgptr->ccfg);
	show_regs(regs);
	tx4925_dump_pcic_settings();
	panic("PCI error at PC:%08lx.", regs->cp0_epc);
}

static struct irqaction pcic_action = {
	tx4925_pcierr_interrupt, 0, 0, "PCI-C", NULL, NULL
};

static struct irqaction pcierr_action = {
	tx4925_pcierr_interrupt, 0, 0, "PCI-ERR", NULL, NULL
};

void __init
toshiba_rbtx4925_pci_irq_init(void)
{
	setup_irq(TX4925_IRQ_IRC_PCIC, &pcic_action);
	setup_irq(TX4925_IRQ_IRC_PCIERR, &pcierr_action);
	return;
}

void
tx4925_reset_pci_pcic(void)
{
	/* Reset PCIC */
	tx4925_ccfgptr->clkctr &= ~TX4925_CONFIG_CLKCTR_PCIRSTI;
	udelay(10000);
	/* clear PCIC reset */
	tx4925_ccfgptr->clkctr |= TX4925_CONFIG_CLKCTR_PCIRSTI;
}

void
print_pci_status(void)
{
	printk("PCI STATUS %lx\n", tx4925_pcicptr->pcistatus);
	printk("PCIC STATUS %lx\n", tx4925_pcicptr->pcicstatus);
}

static unsigned long __init
rbtx4925_find_free_region(int n,
			  unsigned long *bases,
			  unsigned long *sizes,
			  unsigned long begin,
			  unsigned long end, unsigned long *size)
{
	unsigned long base;
	unsigned long sz = *size;
	int i;

	for (; sz; sz /= 2) {
		for (base = begin / sz * sz; base < end; base += sz) {
			for (i = 0; i < n; i++) {
				if (sizes[i] &&
				    base <= bases[i] + (sizes[i] - 1) &&
				    base + (sz - 1) >= bases[i])
					break;
			}
			if (i == n) {
				*size = sz;
				return base;
			}
		}
	}
	return 0;
}

static void
rbtx4925_setup_pci_regions(void)
{
	unsigned long base[4 + 8 + 1];
	unsigned long size[4 + 8 + 1];
	unsigned long mbegin, mend;
	unsigned long rbtx4925_ce_base[8];
	unsigned long rbtx4925_ce_size[8];
	int i;

	/* SDRAMC,EBUSC are configured by PROM */
	for (i = 0; i < 8; i++) {
		if (!(tx4925_ebuscptr->ch[i].cr & 0x8))
			continue;	/* disabled */
		rbtx4925_ce_base[i] = tx4925_ebuscptr->ch[i].bar;
		rbtx4925_ce_size[i] =
		    0x00100000 << ((tx4925_ebuscptr->ch[i].cr >> 8) & 0xf);
	}

	if (mips_pci_mem_base || mips_pci_io_base)
		return;		/* done */

	for (i = 0; i < sizeof (base) / sizeof (base[0]); i++)
		base[i] = size[i] = 0;

	for (i = 0; i < 4; i++) {
		if (!(tx4925_sdramcptr->cr[i] & 0x00000200))
			continue;	/* disabled */
		base[i] = tx4925_sdramcptr->cr[i] & 0xffe00000;
		size[i] = ((tx4925_sdramcptr->cr[i] >> 10) + 1) << 21;
	}
	for (i = 0; i < 8; i++) {
		if (!(tx4925_ebuscptr->ch[i].cr & 0x8))
			continue;	/* disabled */
		base[i + 4] = rbtx4925_ce_base[i];
		size[i + 4] = rbtx4925_ce_size[i];
	}
	mbegin = base[0] + size[0];	/* end of SDRAM ch 0 */
	mend = base[4];		/* begin of CE0 */

	mips_pci_mem_base =
	    rbtx4925_find_free_region(sizeof (base) / sizeof (base[0]),
				      base, size, mbegin, mend,
				      &mips_pci_mem_size);

	base[4 + 8] = mips_pci_mem_base;
	size[4 + 8] = mips_pci_mem_size;

	mips_pci_io_base =
	    rbtx4925_find_free_region(sizeof (base) / sizeof (base[0]), base,
				      size, mbegin, mend, &mips_pci_io_size);

}

extern struct resource pci_io_resource;
extern struct resource pci_mem_resource;
void
tx4925_pci_setup(void)
{
	static int called = 0;
	extern unsigned int tx4925_get_mem_size(void);

	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_PCI2, "-\n");
	rbtx4925_setup_pci_regions();

	/* setup PCI resources after region setup */
	pci_io_resource.start = PCIBIOS_MIN_IO;
	pci_io_resource.end = PCIBIOS_MIN_IO + mips_pci_io_size - 1;
	pci_mem_resource.start = mips_pci_mem_base;
	pci_mem_resource.end = mips_pci_mem_base + mips_pci_mem_size - 1;
	mips_memory_upper = tx4925_get_mem_size() << 20;
	mips_memory_upper += KSEG0;

	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_PCI2,
				       "0x%08lx=mips_memory_upper\n",
				       mips_memory_upper);
	if (tx4925_memory_upper_max
	    && mips_memory_upper > tx4925_memory_upper_max) {
		mips_memory_upper = tx4925_memory_upper_max;
		printk("limiting memory_upper to 0x%08lx\n", mips_memory_upper);
	}

	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_PCI2,
				       "0x%08lx=mips_pci_io_base\n",
				       mips_pci_io_base);
	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_PCI2,
				       "0x%08lx=mips_pci_io_size\n",
				       mips_pci_io_size);
	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_PCI2,
				       "0x%08lx=mips_pci_mem_base\n",
				       mips_pci_mem_base);
	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_PCI2,
				       "0x%08lx=mips_pci_mem_size\n",
				       mips_pci_mem_size);
	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_PCI2,
				       "0x%08lx=pci_io_resource.start\n",
				       pci_io_resource.start);
	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_PCI2,
				       "0x%08lx=pci_io_resource.end\n",
				       pci_io_resource.end);
	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_PCI2,
				       "0x%08lx=pci_mem_resource.start\n",
				       pci_mem_resource.start);
	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_PCI2,
				       "0x%08lx=pci_mem_resource.end\n",
				       pci_mem_resource.end);
	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_PCI2,
				       "0x%08lx=mips_io_port_base",
				       mips_io_port_base);
	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_PCI2,
				       "setup pci_io_resource  to 0x%08lx 0x%08lx\n",
				       pci_io_resource.start,
				       pci_io_resource.end);
	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_PCI2,
				       "setup pci_mem_resource to 0x%08lx 0x%08lx\n",
				       pci_mem_resource.start,
				       pci_mem_resource.end);
	if (!called) {
		printk("TX4925 PCIC -- DID:%04x VID:%04x RID:%02x Arbiter:%s\n",
		       (unsigned short) (tx4925_pcicptr->pciid >> 16),
		       (unsigned short) (tx4925_pcicptr->pciid & 0xffff),
		       (unsigned short) (tx4925_pcicptr->pciccrev & 0xff),
		       (tx4925_ccfgptr->
			ccfg & TX4925_CONFIG_CCFG_PCIARB) ? "External" :
		       "Internal");
		called = 1;
	}
	printk("TX4925 PCIC -- PCICLK:");
	/* GB->PCI mappings */
	tx4925_pcicptr->g2piomask = (mips_pci_io_size - 1);
	tx4925_pcicptr->g2piogbase = mips_pci_io_base;
	tx4925_pcicptr->g2piopbase = 0;
	tx4925_pcicptr->g2pm0mask = (mips_pci_mem_size - 1);
	tx4925_pcicptr->g2pm0gbase = mips_pci_mem_base;
	tx4925_pcicptr->g2pm0pbase = mips_pci_mem_base;
	tx4925_pcicptr->g2pm1mask = 0;
	tx4925_pcicptr->g2pm1gbase = 0;
	tx4925_pcicptr->g2pm2pbase = 0;
	tx4925_pcicptr->g2pm2mask = 0;
	tx4925_pcicptr->g2pm2gbase = 0;
	tx4925_pcicptr->g2pm2pbase = 0;
	/* PCI->GB mappings (I/O) */
	tx4925_pcicptr->p2giopbase = 0;	/* 256B */
	tx4925_pcicptr->p2giogbase = 0;
	tx4925_pcicptr->p2gioctr =
#ifdef TX4925_SUPPORT_COMMAND_IO
	    TX4925_PCIC_P2GIOCTR_P2GIOEN
#ifdef __BIG_ENDIAN
	    | TX4925_PCIC_P2GIOCTR_BSWAP
#endif
	    ;
#else
	    0;
#endif
	/* PCI->GB mappings (MEMORY) */
	tx4925_pcicptr->p2gm0pbase = 0;
	tx4925_pcicptr->p2gm0gbase = 0;
	tx4925_pcicptr->p2gm0ctr =
	    ((mips_memory_upper - 1) & TX4925_PCIC_P2GMnCTR_AM_MASK)
	    | TX4925_PCIC_P2GMnCTR_TPRBL_8DW
	    | TX4925_PCIC_P2GMnCTR_MEMnPE | TX4925_PCIC_P2GMnCTR_P2GMnEN
#ifdef __BIG_ENDIAN
	    | TX4925_PCIC_P2GMnCTR_BSWAP
#endif
	    ;
	tx4925_pcicptr->p2gm1ctr = 0;
	tx4925_pcicptr->p2gm2ctr = 0;
	/* Enable Initiator Memory 0 Space, I/O Space, Config */
	tx4925_pcicptr->g2pcfg =
	    TX4925_PCIC_G2PCFG_G2PM0EN | TX4925_PCIC_G2PCFG_G2PIOEN
#ifdef __BIG_ENDIAN
	    | TX4925_PCIC_G2PCFG_BSWAPM0
	    | TX4925_PCIC_G2PCFG_BSWAPM1
	    | TX4925_PCIC_G2PCFG_BSWAPM2 | TX4925_PCIC_G2PCFG_BSWAPIO
// needs to be off                | TX4925_PCIC_G2PCFG_BSWAPI
#endif
	    ;
	tx4925_pcicptr->pciccfg =
		(tx4925_pcicptr->pciccfg & TX4925_PCIC_PCICCFG_GBWC_MASK) |
		 TX4925_PCIC_PCICCFG_RESERVE;
	                                                    
	tx4925_pcicptr->pcicfg1 = 0;
	if (tx4925_pcic_trdyto >= 0) {
		tx4925_pcicptr->g2ptocnt &= ~0xff;
		tx4925_pcicptr->g2ptocnt |= (tx4925_pcic_trdyto & 0xff);
	}

	if (tx4925_pcic_retryto >= 0) {
		tx4925_pcicptr->g2ptocnt &= ~0xff00;
		tx4925_pcicptr->g2ptocnt |= ((tx4925_pcic_retryto<<8) & 0xff00);
	}

	/* Clear All Local Bus Status */
	tx4925_pcicptr->pcicstatus = TX4925_PCIC_PCICSTATUS_ALL;
	/* Enable All Local Bus Interrupts */
	tx4925_pcicptr->pcicmask = TX4925_PCIC_PCICSTATUS_ALL;
	/* Clear All Initiator Status */
	tx4925_pcicptr->g2pstatus = TX4925_PCIC_G2PSTATUS_ALL;
	/* Enable All Initiator Interrupts */
	tx4925_pcicptr->g2pmask = TX4925_PCIC_G2PSTATUS_ALL;
	tx4925_pcicptr->g2pmask &= ~TX4925_PCIC_G2PSTATUS_MDFE;
	/* Clear All PCI Status Error */
	tx4925_pcicptr->pcistatus =
	    (tx4925_pcicptr->
	     pcistatus & 0x0000ffff) | (TX4925_PCIC_PCISTATUS_ALL << 16);
	/* Enable All PCI Status Error Interrupts */
	tx4925_pcicptr->pcimask = TX4925_PCIC_PCISTATUS_ALL;

	/* PCIC Int => IRC IRQ */
	tx4925_pcicptr->pcicfg2 =
	    (tx4925_pcicptr->pcicfg2 & 0xffffff00) | TX4925_IRQ_IRC_PCIC;

	if (tx4925_ccfgptr->ccfg & TX4925_CONFIG_CCFG_PCIARB) {
		/* XXX */
	} else {
		/* Reset Bus Arbiter */
		tx4925_pcicptr->pbacfg = TX4925_PCIC_PBACFG_RPBA;
		/* Enable Bus Arbiter */
		tx4925_pcicptr->pbacfg = TX4925_PCIC_PBACFG_PBAEN;
	}

	tx4925_pcicptr->pcistatus = PCI_COMMAND_MASTER | PCI_COMMAND_MEMORY |
#ifdef TX4925_SUPPORT_COMMAND_IO
	    PCI_COMMAND_IO |
#endif
	    PCI_COMMAND_PARITY | PCI_COMMAND_SERR;
	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_PCI2,
				       ":pci setup complete:\n");
	//tx4925_dump_pcic_settings();
	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_PCI2, "+\n");
	return;
}
#endif				/* CONFIG_PCI */

#ifdef CONFIG_PCMCIA_RBTX4925
/* use CE5,6,7 for PCMCIA (ATTR,MEM:64MB, IO:1MB) */
struct _pcmcia_map {
	unsigned long mode;
	unsigned long ce;
	unsigned long base;
	unsigned long size;
	char *name;
};

static void __init
rbtx4925_pcmcia_setup(void)
{
	struct _pcmcia_map pcmcia[] = {
		{
		 3,		/* mode */
		 7,		/* ce   */
		 RBTX4925_PCMCIA_ATTR,	/* base */
		 RBTX4925_PCMCIA_ATTR_SIZE,	/* size */
		 "pcmcia attr"	/* name */
		 },
		{
		 1,		/* mode */
		 6,		/* ce   */
		 RBTX4925_PCMCIA_MEM,	/* base */
		 RBTX4925_PCMCIA_MEM_SIZE,	/* size */
		 "pcmcia mem"	/* name */
		 },
		{
		 2,		/* mode */
		 3,		/* ce   */
		 RBTX4925_PCMCIA_IO,	/* base */
		 RBTX4925_PCMCIA_IO_SIZE,	/* size */
		 "pcmcia io"	/* name */
		 }
	};
	unsigned long sp;
	unsigned long bar, base, cs;
	int i, ccfg_ok, pcfg_ok;

	sp = (tx4925_ccfgptr->ccfg >> 6) & 3;	/* SYSSP */
	for (i = 0; i < (sizeof (pcmcia) / sizeof (struct _pcmcia_map)); i++) {
		bar = (TX4925_EBUSC_EBBAR0 + (0x08 * pcmcia[i].ce));
		base = TX4925_RD(TX4925_REG(bar));
		if (base)
			return;
	}
	for (i = 0; i < (sizeof (pcmcia) / sizeof (struct _pcmcia_map)); i++) {
		/* request regions */
		/* request_region( pcmcia[i].base, pcmcia[i].size, pcmcia[i].name ); */

		/* calculate CS size */
		for (cs = 0; (0x100000 << cs) < pcmcia[i].size; cs++) ;

		/* setup EBUSC
		 *                  * 16bit width, SYSCLK speed
		 *                                   * FIXME: tune PWT,WT,SHWT
		 *                                                    */
		tx4925_ebuscptr->ch[pcmcia[i].ce].bar = pcmcia[i].base;
		tx4925_ebuscptr->ch[pcmcia[i].ce].cr = (0x0063f04b |
							(pcmcia[i].mode << 24) |
							(cs << 8) | (sp << 4));

	}

	ccfg_ok = (!(tx4925_ccfgptr->ccfg & TX4925_CONFIG_CCFG_PCTRCE) ? 1 : 0);
	pcfg_ok = ((tx4925_ccfgptr->pcfg & TX4925_PCFG_SELCARD(0)) ? 1 : 0);
	if (ccfg_ok && pcfg_ok) {
		/* enable PCMCIA */
		RBTX4925_IOC_REG(PIOSEL) &= ~RBTX4925_PIOSEL_NOPCMCIA;
	} else {
		/* disable PCMCIA */
		RBTX4925_IOC_REG(PIOSEL) |= RBTX4925_PIOSEL_NOPCMCIA;
		printk("%s: disable PCMCIA [CCFG:%s PCFG:%s]\n", __FUNCTION__,
		       (ccfg_ok ? "OK" : "NG"), (pcfg_ok ? "OK" : "NG")
		    );
	}
}
#endif				/* CONFIG_PCMCIA_RBTX4925 */

void
toshiba_rbtx4925_restart(char *command)
{
	printk(KERN_NOTICE "System Rebooting...\n");

	/* enable the s/w reset register */
	reg_wr08(RBTX4925_SW_RESET_ENABLE, RBTX4925_SW_RESET_ENABLE_SET);

	/* wait for enable to be seen */
	while ((reg_rd08(RBTX4925_SW_RESET_ENABLE) &
		RBTX4925_SW_RESET_ENABLE_SET) == 0x00) ;
	/* do a pci s/w reset */
	reg_wr08(RBTX4925_SW_RESET_PCI, RBTX4925_SW_RESET_PCI_SET);
	/* do a mpu s/w reset */
	reg_wr08(RBTX4925_SW_RESET_DO, RBTX4925_SW_RESET_DO_SET);
	/* do something passive while waiting for reset */
	cli();
	while (1) {
		asm_wait();
	}

	/* no return */
}

void
toshiba_rbtx4925_halt(void)
{
	printk(KERN_NOTICE "System Halted\n");
	cli();
	while (1) {
		asm_wait();
	}
	/* no return */
}

void
toshiba_rbtx4925_power_off(void)
{
	toshiba_rbtx4925_halt();
	/* no return */
}

void __init
toshiba_rbtx4925_setup(void)
{
	char* argptr;

	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_SETUP, "-\n");
	/* f/w leaves this on at startup */
	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_SETUP,
				       ":Clearing STO_ERL.\n");
	clear_c0_status(ST0_ERL);
#ifdef TOSHIBA_RBTX4925_SETUP_DEBUG
	{
		extern void dump_cp0(char *);
		dump_cp0("toshiba_rbtx4925_early_fw_fixup");
	}
#endif

	/* set TOCNT register to max value */
	tx4925_ccfgptr->tocnt = 0x0000ffff;

	toshiba_rbtx4925_mplex_setup();

	/* setup irq stuff */
	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_SETUP,
				       ":Setting up tx4925 pic.\n");
	TX4925_WR(TX4925_MKA(TX4925_IRC_IRDM0), 0x00000040);	/* irq trigger */
	TX4925_WR(TX4925_MKA(TX4925_IRC_IRDM1), 0x00000000);	/* irq trigger */
	/* setup serial stuff */
	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_SETUP,
				       ":Setting up tx4925 sio.\n");
	TX4925_WR(0xff1ff314, 0x00000000);	/* h/w flow control off */
	TX4925_WR(0xff1ff414, 0x00000000);	/* h/w flow control off */

	set_io_port_base(KSEG1 + RBTX4925_ISA_IO_OFFSET);
	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_SETUP,
				       ":mips_io_port_base=0x%08lx\n",
				       mips_io_port_base);

	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_SETUP,
				       ":Resource\n");

	ioport_resource.start = 0x1000;
	ioport_resource.end = 0xffffffff;
	iomem_resource.start = 0x1000;
	iomem_resource.end = 0xffffffff;
	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_SETUP,
				       ":ResetRoutines\n");
	_machine_restart = toshiba_rbtx4925_restart;
	_machine_halt = toshiba_rbtx4925_halt;
	_machine_power_off = toshiba_rbtx4925_power_off;

#ifdef CONFIG_IDE
	{
		TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_SETUP,
					       ":ide_ops=&std_ide_ops(modified)\n");
#ifdef CONFIG_PCMCIA_RBTX4925
		ide_ops = &rbtx4925_ide_ops;
#else
		ide_ops = &std_ide_ops;
#endif
	}
#else
	{
		TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_SETUP,
					       ":ide_ops=<NOT_CONFIG>\n");
	}
#endif

#ifdef CONFIG_FB
	{
		conswitchp = &dummy_con;
	}
#endif

#ifdef CONFIG_PCMCIA_RBTX4925
	/* use CE5,6,7 for PCMCIA (ATTR,MEM:64MB, IO:1MB) */
	if (!(tx4925_ccfgptr->ccfg & TX4925_CONFIG_CCFG_PCTRCE) &&
	    (tx4925_ccfgptr->pcfg & TX4925_PCFG_SELCARD(0))) {
		rbtx4925_pcmcia_setup();
	}
#endif				/* CONFIG_PCMCIA_RBTX4925 */

#ifdef CONFIG_PCI

	/* PCIC */
#define TOSHIBA_RBTX4925_SETUP_PCI1        ( 1 <<  8 )
	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_PCI1,
				       "PCI mode is %lx, pci arb is %lx\n",
				       (unsigned long) tx4925_ccfgptr->
				       ccfg & TX4925_CONFIG_CCFG_PCIMODE,
				       (unsigned long) tx4925_ccfgptr->
				       ccfg & TX4925_CONFIG_CCFG_PCIARB);
	/* CCFG */
	/* check if enable Timeout BusError */
	if (tx4925_ccfg_toeon)
		tx4925_ccfgptr->ccfg |= TX4925_CONFIG_CCFG_TOE;
	tx4925_pci_setup();
#endif				/* CONFIG_PCI */
	/* this is on ISA bus behind PCI bus, so need PCI up first */
#ifdef CONFIG_TOSHIBA_FPCIB0
	{
		TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_SETUP,
					       ":fpcibo=yes\n");
		TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_SETUP,
					       ":smsc_fdc37m81x_init()\n");
		smsc_fdc37m81x_init(0x3f0);
		TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_SETUP,
					       ":smsc_fdc37m81x_config_beg()\n");
		smsc_fdc37m81x_config_beg();
		TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_SETUP,
					       ":smsc_fdc37m81x_config_set(KBD)\n");
		smsc_fdc37m81x_config_set(SMSC_FDC37M81X_DNUM,
					  SMSC_FDC37M81X_KBD);
		smsc_fdc37m81x_config_set(SMSC_FDC37M81X_INT, 1);
		smsc_fdc37m81x_config_set(SMSC_FDC37M81X_INT2, 12);
		smsc_fdc37m81x_config_set(SMSC_FDC37M81X_ACTIVE, 1);
		smsc_fdc37m81x_config_end();
		TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_SETUP,
					       ":smsc_fdc37m81x_config_end()\n");
	}
#else
	{
		TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_SETUP,
					       ":fpcibo=no\n");
	}
#endif

#ifdef CONFIG_SERIAL_TXX9_CONSOLE
        argptr = prom_getcmdline();
        if (strstr(argptr, "console=") == NULL) {
                strcat(argptr, " console=ttyS0,38400");
        }
#endif

#ifdef CONFIG_IP_PNP
        argptr = prom_getcmdline();
        if (strstr(argptr, "ip=") == NULL) {
                strcat(argptr, " ip=any");
        }
#endif

#ifdef CONFIG_NE2000
        argptr = prom_getcmdline();
        if (strstr(argptr, "ne_eth=") == NULL) {
		char ne_eth[60];
		sprintf(ne_eth," ne_eth=0x%08x,%d",RBTX4925_RTL_8019_BASE,RBTX4925_RTL_8019_IRQ );
                strcat(argptr, ne_eth);
                /* strcat(argptr, " ne_eth=0x17020280,27"); pcmcia=n */
                /* strcat(argptr, " ne_eth=0x0a020280,27"); pcmcia=y */
        }
#endif

#ifdef CONFIG_ROOT_NFS
	argptr = prom_getcmdline();
	if (strstr(argptr, "root=") == NULL) {
		strcat(argptr, " root=/dev/nfs rw");
	}
#endif

	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_SETUP, "+\n");
	return;
}

void __init
toshiba_rbtx4925_time_init(void)
{
	extern char *prom_getcmdline(void);

	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_TIME_INIT, "-\n");

	mips_counter_frequency = 100000000;

	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_TIME_INIT, "+\n");
	return;
}

void __init
toshiba_rbtx4925_timer_setup(struct irqaction *irq)
{
	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_TIMER_SETUP,
				       "-\n");
	TOSHIBA_RBTX4925_SETUP_DPRINTK(TOSHIBA_RBTX4925_SETUP_TIMER_SETUP,
				       "+\n");
	return;
}
