/*
 * linux/arch/mips/tx4925/toshiba_rbtx4925/prom.c
 *
 * rbtx4925 specific prom routines
 *
 * Author: MontaVista Software, Inc.  source@mvista.com
 *
 * Copyright 2001-2002 MontaVista Software Inc.
 *
 * 2003 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */

#include <linux/config.h>
#include <linux/init.h>
#include <linux/mm.h>
#include <linux/sched.h>
#include <linux/bootmem.h>

#include <asm/addrspace.h>
#include <asm/bootinfo.h>
#include <asm/tx4925/tx4925.h>

#ifndef CONFIG_CMDLINE_BOOL
#define CONFIG_CMDLINE ""
#endif

char arcs_cmdline[CL_SIZE] = CONFIG_CMDLINE;

void __init
prom_init_cmdline(int argc, char **argv)
{
	int i;			/* Always ignore the "-c" at argv[0] */

	/* ignore all built-in args if any f/w args given */
	if (argc > 1) {
		*arcs_cmdline = '\0';
	}

	for (i = 1; i < argc; i++) {
		if (i != 1) {
			strcat(arcs_cmdline, " ");
		}
		strcat(arcs_cmdline, argv[i]);
	}

	return;
}

void __init
prom_init(int argc, char **argv, char **envp, int *pvec)
{
	extern int tx4925_get_mem_size(void);
	int msize;

	prom_init_cmdline(argc, argv);

	mips_machgroup = MACH_GROUP_TOSHIBA;
	mips_machtype = MACH_TOSHIBA_RBTX4925;

	msize = tx4925_get_mem_size();
	add_memory_region(0, msize << 20, BOOT_MEM_RAM);

	return;
}

char * __init prom_getcmdline(void)
{
	return &(arcs_cmdline[0]);
}

void __init
prom_free_prom_memory(void)
{
	return;
}

void __init
prom_fixup_mem_map(unsigned long start, unsigned long end)
{
	return;
}

const char *get_system_type(void)
{
	return "Toshiba RBTX4925";
}

