/*
 * linux/arch/mips/tx4925/toshiba_rbtx4925/pci_fixup.c
 *
 * Toshiba rbtx4925 pci routines
 *
 * Author: MontaVista Software, Inc.  source@mvista.com
 *
 * Copyright (C) 2000 RidgeRun, Inc.
 * Author: RidgeRun, Inc.
 *   glonnon@ridgerun.com, skranz@ridgerun.com, stevej@ridgerun.com
 *
 * Copyright 2001 MontaVista Software Inc.
 * Author: jsun@mvista.com or jsun@junsun.net
 *
 * Copyright 2002 MontaVista Software Inc.
 * Author: Michael Pruznick, michael_pruznick@mvista.com
 *
 * Copyright (C) 2000-2001 Toshiba Corporation 
 *
 * 2003 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */

#include <linux/config.h>

#include <linux/types.h>
#include <linux/pci.h>
#include <linux/kernel.h>
#include <linux/init.h>

#include <asm/tx4925/tx4925.h>
#include <asm/tx4925/tx4925_pci.h>

#undef  DEBUG
#ifdef  DEBUG
#define DBG(x...)       printk(x)
#else
#define DBG(x...)
#endif

void __init
pcibios_fixup_resources(struct pci_dev *dev)
{
	/* nothing to do here */
}

void __init
pcibios_fixup(void)
{
	/* nothing to do here */
}

int
pci_get_irq(struct pci_dev *dev, int pin)
{
	unsigned char irq = pin;

	DBG("pci_get_irq: pin is %d, slot is %d\n", pin, PCI_SLOT(dev->devfn));
	/* IRQ rotation */
	irq--;			/* 0-3 */
	if (dev->bus->parent == NULL &&
	    (PCI_SLOT(dev->devfn) == TX4925_PCIC_IDSEL_AD_TO_SLOT(23))) {
		irq = (irq + 0 + PCI_SLOT(dev->devfn)) % 4;
		DBG("onboard pci slot: irq from slot %d is %d\n",
		    PCI_SLOT(dev->devfn), irq);
	} else {
		/* PCI Backplane */
		irq = (irq + 3 + PCI_SLOT(dev->devfn)) % 4;
		DBG("backplan slot: irq from slot %d is %d\n",
		    PCI_SLOT(dev->devfn), irq);
	}
	irq++;			/* 1-4 */

	switch (irq) {
	case 1:
		irq = TOSHIBA_RBTX4925_IRQ_IOC_PCI_A;
		break;
	case 2:
		irq = TOSHIBA_RBTX4925_IRQ_IOC_PCI_B;
		break;
	case 3:
		irq = TOSHIBA_RBTX4925_IRQ_IOC_PCI_C;
		break;
	case 4:
		irq = TOSHIBA_RBTX4925_IRQ_IOC_PCI_D;
		break;
	}
	DBG("assigned irq %d\n", irq);
	return irq;
}

void __init
pcibios_fixup_irqs(void)
{
	unsigned char pin;
	unsigned char irq;
	struct pci_dev *dev;
	unsigned int id;

	pci_for_each_dev(dev) {
		DBG("FIXUP:\n");
		DBG(" devfn=0x%02x (0x%02x:0x%02x)\n",
		    dev->devfn, PCI_SLOT(dev->devfn), PCI_FUNC(dev->devfn));

		pci_read_config_dword(dev, PCI_VENDOR_ID, &id);
		DBG(" id=0x%08x\n", id);

		pci_read_config_byte(dev, PCI_INTERRUPT_LINE, &irq);
		DBG(" line=0x%02x/%d\n", irq, irq);

		pci_read_config_byte(dev, PCI_INTERRUPT_PIN, &pin);
		DBG(" pin=%d\n", pin);

#ifdef DEBUG
		{
			unsigned int tmp;
			pci_read_config_dword(dev, 0x10, &tmp);
			DBG(" bar0:0x10=0x%08x\n", tmp);
			pci_read_config_dword(dev, 0x14, &tmp);
			DBG(" bar1:0x14=0x%08x\n", tmp);
			pci_read_config_dword(dev, 0x1c, &tmp);
			DBG(" bar2:0x1c=0x%08x\n", tmp);
			pci_read_config_dword(dev, 0x20, &tmp);
			DBG(" bar3:0x20=0x%08x\n", tmp);
			pci_read_config_dword(dev, 0x24, &tmp);
			DBG(" bar4:0x24=0x%08x\n", tmp);
		}
#endif

		irq = 0;

		if (pin == 0) {
			DBG(" auto irq (now=%d) -- skipping pin=0\n", irq);
		} else {
			DBG(" auto irq (was=%d)\n", irq);
			irq = pci_get_irq(dev, pin);
			pci_write_config_byte(dev, PCI_INTERRUPT_LINE, irq);
			dev->irq = irq;
			DBG(" auto irq (now=%d)\n", irq);
		}

		pci_read_config_byte(dev, PCI_INTERRUPT_LINE, &irq);
		printk(KERN_INFO "PCI: 0x%02x:0x%02x(0x%02x,0x%02x) IRQ=%d\n",
		       dev->bus->number, dev->devfn, PCI_SLOT(dev->devfn),
		       PCI_FUNC(dev->devfn), irq);

	}

}
