/*
 * linux/arch/mips/tx4925/common/rtc.c
 *
 * sample driver for TX4925 built-in rtc 
 *
 * Author: MontaVista Software, Inc. source@mvista.com
 *
 * 2003 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */

#include <linux/errno.h>
#include <linux/init.h>
#include <linux/kernel_stat.h>
#include <linux/module.h>
#include <linux/signal.h>
#include <linux/sched.h>
#include <linux/types.h>
#include <linux/interrupt.h>
#include <linux/ioport.h>
#include <linux/timex.h>
#include <linux/slab.h>
#include <linux/random.h>
#include <linux/irq.h>
#include <asm/bitops.h>
#include <asm/bootinfo.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/mipsregs.h>
#include <asm/system.h>
#include <asm/tx4925/tx4925_rtc.h>

struct tx4925_rtc_st *tx4925_rtc_ptr = (struct tx4925_rtc_st *) TX4925_RTC_BASE;

static u64
tx4925_rtc_get_count(void)
{
	u32 count_hi;
	u32 count_lo;
	u64 count_xx;

	count_hi = tx4925_rtc_ptr->rtchi;
	count_lo = tx4925_rtc_ptr->rtclo;
	count_xx = (((((u64) count_hi) & TX4925_RTC_HI_MASK) << 32) | count_lo);

	return (count_xx);
}

unsigned long
tx4925_rtc_get_time(void)
{
	u64 count1;
	u64 count2;
	u32 alarm;
	u32 count;

	/* manual says need to read same value twice */
	do {
		count1 = tx4925_rtc_get_count();
		count2 = tx4925_rtc_get_count();
	} while (count1 != count2);

	alarm = tx4925_rtc_ptr->alarmlo;	/* last clear epoch */
	count = alarm + (u32) (count2 >> TX4925_RTC_FREQ_SHIFT);

	return (count);
}

int
tx4925_rtc_set_time(unsigned long t)
{

	/* save clear epoch in alarm */
	tx4925_rtc_ptr->alarmlo = t;

	/* stop, clear rtc */
	tx4925_rtc_ptr->rtcctrl |= TX4925_RTC_RTCCTRL_RTCCLR;

	/* restart rtc */
	tx4925_rtc_ptr->rtcctrl &= (~TX4925_RTC_RTCCTRL_RTCCLR);

	t = tx4925_rtc_get_time();

	return (t);
}

void __init
tx4925_rtc_init(unsigned long base)
{
	if (base) {
		tx4925_rtc_ptr = (struct tx4925_rtc_st *) base;
	}

	tx4925_rtc_ptr->alarmhi = 0;
	tx4925_rtc_ptr->rtcctrl &=
	    ~(TX4925_RTC_RTCCTRL_DISRTINT | TX4925_RTC_RTCCTRL_DISALINT);

	return;
}
