/*
 * linux/arch/mips/tx4925/common/prom.c
 *
 * common tx4925 memory interface
 *
 * Author: MontaVista Software, Inc. source@mvista.com
 *
 * 2003 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */

#include <linux/init.h>
#include <linux/mm.h>
#include <linux/sched.h>
#include <linux/bootmem.h>

#include <asm/addrspace.h>
#include <asm/bootinfo.h>
#include <asm/tx4925/tx4925.h>

#undef  TX4925_PROM_DEBUG
#ifdef  TX4925_PROM_DEBUG
#define TX4925_PROM_DEBUG_DPRINTK(str...) \
	do { \
           char tmp[100]; \
           sprintf( tmp, str ); \
           printk( "%s(%s:%u)::%s", __FUNCTION__, __FILE__, __LINE__, tmp ); \
        } while ( 0 )
#else
#define TX4925_PROM_DEBUG_DPRINTK(str...)
#endif

static unsigned int __init
tx4925_process_sdccr(vu32 * addr)
{
	vu32 val;
	unsigned int sdccr_ce;
	unsigned int sdccr_rs;
	unsigned int sdccr_cs;
	unsigned int sdccr_mw;
	unsigned int rs = 0;
	unsigned int cs = 0;
	unsigned int mw = 0;
	unsigned int bc = 4;
	unsigned int msize = 0;

	TX4925_PROM_DEBUG_DPRINTK("tx4925_process_sdccr()-\n");

	val = (*((vu32 *) (addr)));

	TX4925_PROM_DEBUG_DPRINTK("tx4925_process_sdccr()= [sdccr_xx=0x%08x]\n",
				  val);

	/* MVMCP -- need #defs for these bits masks */
	sdccr_ce = ((val & (1 << 9)) >> 9);
	sdccr_rs = ((val & (3 << 4)) >> 4);
	sdccr_cs = ((val & (7 << 1)) >> 1);
	sdccr_mw = ((val & (1 << 0)) >> 0);

	TX4925_PROM_DEBUG_DPRINTK("tx4925_process_sdccr()= [sdccr_ce=0x%08x]\n",
				  sdccr_ce);
	TX4925_PROM_DEBUG_DPRINTK("tx4925_process_sdccr()= [sdccr_rs=0x%08x]\n",
				  sdccr_rs);
	TX4925_PROM_DEBUG_DPRINTK("tx4925_process_sdccr()= [sdccr_cs=0x%08x]\n",
				  sdccr_cs);
	TX4925_PROM_DEBUG_DPRINTK("tx4925_process_sdccr()= [sdccr_mw=0x%08x]\n",
				  sdccr_mw);

	if (sdccr_ce) {
		TX4925_PROM_DEBUG_DPRINTK
		    ("tx4925_process_sdccr()= [______bc=%d]\n", bc);
		switch (sdccr_rs) {
		case 0:{
				rs = 2048;
				break;
			}
		case 1:{
				rs = 4096;
				break;
			}
		case 2:{
				rs = 8192;
				break;
			}
		default:{
				rs = 0;
				break;
			}
		}
		TX4925_PROM_DEBUG_DPRINTK
		    ("tx4925_process_sdccr()= [______rs=%d]\n", rs);
		switch (sdccr_cs) {
		case 0:{
				cs = 256;
				break;
			}
		case 1:{
				cs = 512;
				break;
			}
		case 2:{
				cs = 1024;
				break;
			}
		case 3:{
				cs = 2048;
				break;
			}
		case 4:{
				cs = 4096;
				break;
			}
		default:{
				cs = 0;
				break;
			}
		}
		TX4925_PROM_DEBUG_DPRINTK
		    ("tx4925_process_sdccr()= [______cs=%d]\n", cs);
		switch (sdccr_mw) {
		case 0:{
				mw = 4;
				break;
			}	/* 4 bytes = 32 bits */
		case 1:{
				mw = 2;
				break;
			}	/* 2 bytes = 16 bits */
		}
		TX4925_PROM_DEBUG_DPRINTK
		    ("tx4925_process_sdccr()= [______mw=%d]\n", mw);
	}

	/*           bytes per chip    MB per chip          bank count */
	msize = (((rs * cs * mw) / (1024 * 1024)) * (bc));

	/* MVMCP -- bc hard coded to 4 from table 9.3.1     */
	/*          boad supports bc=2 but no way to detect */

	TX4925_PROM_DEBUG_DPRINTK("tx4925_process_sdccr()= [___msize=%d]\n",
				  msize);

	TX4925_PROM_DEBUG_DPRINTK("tx4925_process_sdccr()+\n");

	return (msize);
}

unsigned int __init
tx4925_get_mem_size(void)
{
	unsigned int c0;
	unsigned int c1;
	unsigned int c2;
	unsigned int c3;
	unsigned int total;

	TX4925_PROM_DEBUG_DPRINTK("tx4925_get_mem_size()-\n");

	/* MVMCP -- need #defs for these registers */
	c0 = tx4925_process_sdccr((vu32 *) 0xff1f8000);
	c1 = tx4925_process_sdccr((vu32 *) 0xff1f8004);
	c2 = tx4925_process_sdccr((vu32 *) 0xff1f8008);
	c3 = tx4925_process_sdccr((vu32 *) 0xff1f800c);
	total = c0 + c1 + c2 + c3;

	TX4925_PROM_DEBUG_DPRINTK("tx4925_get_mem_size()= [c0=%d]\n", c0);
	TX4925_PROM_DEBUG_DPRINTK("tx4925_get_mem_size()= [c1=%d]\n", c1);
	TX4925_PROM_DEBUG_DPRINTK("tx4925_get_mem_size()= [c2=%d]\n", c2);
	TX4925_PROM_DEBUG_DPRINTK("tx4925_get_mem_size()= [c3=%d]\n", c3);
	TX4925_PROM_DEBUG_DPRINTK("tx4925_get_mem_size()= [cX=%d]\n", total);

	TX4925_PROM_DEBUG_DPRINTK("tx4925_get_mem_size()+\n");

	return (total);
}
