/* 
 * arch/mips/tx4925/common/dbgio.c
 *  
 * tx4925 kgdb interface
 *  
 * Author: MontaVista Software, Inc. source@mvista.com
 *  
 * 2003 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program 
 * is licensed "as is" without any warranty of any kind, whether express 
 * or implied.
 */ 

#include <asm/mipsregs.h>
#include <asm/system.h>
#include <asm/tx4927/tx4927_mips.h>

u8
getDebugChar(void)
{
#if defined(CONFIG_RICOH_BASIL_S1)
	extern basil_s1_getDebugChar(void);
	return (basil_s1_getDebugChar());
#else
	extern u8 txx9_sio_kdbg_rd(void);
	return (txx9_sio_kdbg_rd());
#endif
}

int
putDebugChar(u8 byte)
{
#if defined(CONFIG_RICOH_BASIL_S1)
	extern basil_s1_putDebugChar(void);
	return (basil_s1_putDebugChar());
#else
	extern int txx9_sio_kdbg_wr( u8 ch );
	return (txx9_sio_kdbg_wr(byte));
#endif
}
