/*
 * linux/arch/mips/tx4925/basil_s1/basil_s1_setup.c
 *
 * Basil-S1 specific setup
 *
 * Author: MontaVista Software, Inc.
 *	    source@mvista.com
 *
 * Copyright 2001-2002 MontaVista Software Inc.
 *
 * Copyright (C) 1996, 1997, 2001  Ralf Baechle
 * Copyright (C) 2000 RidgeRun, Inc.
 * Author: RidgeRun, Inc.
 *   glonnon@ridgerun.com, skranz@ridgerun.com, stevej@ridgerun.com
 *
 * Copyright 2001 MontaVista Software Inc.
 * Author: jsun@mvista.com or jsun@junsun.net
 *
 * Copyright 2002 MontaVista Software Inc.
 * Author: Michael Pruznick, michael_pruznick@mvista.com
 *
 * Copyright (C) 2000-2001 Toshiba Corporation 
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 *  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 *  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <linux/config.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/mm.h>
#include <linux/swap.h>
#include <linux/ioport.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/pci.h>
#include <linux/timex.h>
#include <linux/smp.h>
#include <linux/kernel_stat.h>
#include <linux/spinlock.h>
#include <asm/bootinfo.h>
#include <asm/page.h>
#include <asm/bootinfo.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/pci.h>
#include <asm/processor.h>
#include <asm/ptrace.h>
#include <asm/reboot.h>
#include <asm/cpu.h>
#include <asm/time.h>
#include <linux/version.h>
#include <linux/bootmem.h>
#include <linux/blk.h>
/* #include <linux/console.h> */
#include <linux/rtc_rx5c348.h>
#include <asm/tx4925/basil_s1/basil_s1.h>
#ifdef CONFIG_PCI
#include <asm/tx4925/tx4925_pci.h>
#include <linux/types.h>
#include <linux/pci.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <asm/pci_channel.h>
#endif /* CONFIG_PCI */

#define BASIL_S1_SETUP_DEBUG

#ifdef BASIL_S1_SETUP_DEBUG
#define BASIL_S1_SETUP_NONE	    0x00000000

#define BASIL_S1_SETUP_INFO	    ( 1 <<  0 )
#define BASIL_S1_SETUP_WARN	    ( 1 <<  1 )
#define BASIL_S1_SETUP_EROR	    ( 1 <<  2 )
#define BASIL_S1_SETUP_EFWFU	    ( 1 <<  3 )
#define BASIL_S1_SETUP_SETUP	    ( 1 <<  4 )
#define BASIL_S1_SETUP_TIME_INIT    ( 1 <<  5 )
#define BASIL_S1_SETUP_TIMER_SETUP  ( 1 <<  6 )
#define BASIL_S1_SETUP_PCI1	    ( 1 <<  7 )
#define BASIL_S1_SETUP_PCI2	    ( 1 <<  8 )

#define BASIL_S1_SETUP_ALL	    0777UL
#endif


#ifdef BASIL_S1_SETUP_DEBUG
static const u32 basil_s1_setup_debug_flag = ( BASIL_S1_SETUP_NONE
					//	| BASIL_S1_SETUP_INFO
					//	| BASIL_S1_SETUP_WARN
					//	| BASIL_S1_SETUP_EROR
					//	| BASIL_S1_SETUP_EFWFU  
					//	| BASIL_S1_SETUP_SETUP  
					//	| BASIL_S1_SETUP_TIME_INIT
						| BASIL_S1_SETUP_TIMER_SETUP
					//	| BASIL_S1_SETUP_PCI1
					//	| BASIL_S1_SETUP_PCI2
						);
#endif


#ifdef BASIL_S1_SETUP_DEBUG
#define BASIL_S1_SETUP_DPRINTK(flag,str...) \
	 if ( (basil_s1_setup_debug_flag) & (flag) ) \
	 { \
	    char tmp[100]; \
	    sprintf( tmp, str ); \
	    printk( "%s(%s:%u)::%s", __FUNCTION__, __FILE__, __LINE__, tmp ); \
	 }
#else
#define BASIL_S1_SETUP_DPRINTK(flag,str...)
#endif


/* These functions are used for rebooting or halting the machine*/
extern void basil_s1_restart(char *command);
extern void basil_s1_halt(void);
extern void basil_s1_power_off(void);



void __init
basil_s1_setup_early( void )
{
    vu32 cp0_config;

    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_EFWFU, "-\n" );

    /* f/w leaves this on at startup */
    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_EFWFU, ":Clearing STO_ERL.\n" );
    clear_c0_status(ST0_ERL);

    /* enable caches -- HCP5 does this, pmon does not */
    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_EFWFU, ":Enabling TX49_CONF_IC,TX49_CONF_DC.\n" );
    cp0_config = read_c0_config();
    cp0_config = cp0_config & ~(TX49_CONF_IC|TX49_CONF_DC);
    write_c0_config(cp0_config);


    /* setup irq stuff */
    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_EFWFU, ":Setting up tx4925 pic.\n" );
    TX4925_WR( TX4925_MKA(TX4925_IRC_IRDM0), 0x00000000  ); /* irq level trigger */
    TX4925_WR( TX4925_MKA(TX4925_IRC_IRDM1), 0x00000000  ); /* irq level trigger */

    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_EFWFU, "+\n" );

    return;
}



#ifdef CONFIG_PCI
#undef TX4925_SUPPORT_COMMAND_IO
unsigned long mips_pci_io_base;
unsigned long mips_pci_io_size;
unsigned long mips_pci_mem_base;
unsigned long mips_pci_mem_size;
/* for legacy I/O, PCI I/O PCI Bus address must be 0 */
unsigned long mips_pci_io_pciaddr = 0;
unsigned long mips_memory_upper;
unsigned long tx4925_memory_upper_max = 0;
static int tx4925_ccfg_toeon = 1;
static int tx4925_pcic_trdyto = 0;	 /* default: disabled */
static int tx4925_pcic_retryto = 0;	/* default: disabled */
void tx4925_pci_setup(void);
void tx4925_reset_pci_pcic(void);
#endif

#ifdef CONFIG_PCI
void tx4925_dump_pcic_settings(void)
{
    int i;
    unsigned long *preg = (unsigned long *)tx4925_pcicptr;

    printk("tx4925 pcic settings:");
    for (i = 0, preg =(unsigned long *)tx4925_pcicptr;
	(i < sizeof(struct tx4925_pcic_reg)
	    && preg <&tx4925_pcicptr->g2pcfgdata);
	i += 4, preg++) {
	if (i % 32 == 0) printk("\n%04x:", i);
	if (preg == &tx4925_pcicptr->g2pintack ||
	    preg == &tx4925_pcicptr->g2pspc) {
	    printk(" XXXXXXXX");
	} else {
	    printk(" %08lx", *preg);
	}
    }
    printk("\n");
}

static void tx4925_pcierr_interrupt(int irq, void * dev_id, struct pt_regs * regs)
{

    printk("PCI error interrupt (irq 0x%x).\n", irq);
    printk("pcistat:%04x, g2pstatus:%08lx, pcicstatus:%08lx\n",
	    (unsigned short)(tx4925_pcicptr->pcistatus >> 16),
	    tx4925_pcicptr->g2pstatus,
	    tx4925_pcicptr->pcicstatus);
    printk("ccfg:%08lx, toea:%08lx\n",
	    (unsigned long)tx4925_ccfgptr->ccfg,
	    (unsigned long)tx4925_ccfgptr->toea);
    show_regs(regs);
    tx4925_dump_pcic_settings();
    panic("PCI error at PC:%08lx.", regs->cp0_epc);
}

static struct irqaction pcic_action = {
    tx4925_pcierr_interrupt, 0, 0, "PCI-C", NULL, NULL
};

static struct irqaction pcierr_action = {
    tx4925_pcierr_interrupt, 0, 0, "PCI-ERR", NULL, NULL
};


void __init
basil_s1_pci_irq_init( void )
{
    setup_irq(TX4925_IRQ_IRC_PCIC,   &pcic_action);
    setup_irq(TX4925_IRQ_IRC_PCIERR, &pcierr_action);	  
    return;
}

void tx4925_reset_pci_pcic(void)
{
    /* Reset PCIC */
    tx4925_ccfgptr->clkctr &= ~TX4925_CLKCTR_PCIRSTI;
    udelay(10000);
    /* clear PCIC reset */
    tx4925_ccfgptr->clkctr |= TX4925_CLKCTR_PCIRSTI;
}
#endif /* CONFIG_PCI */


#ifdef CONFIG_PCI
void print_pci_status(void)
{
    printk("PCI STATUS %lx\n",tx4925_pcicptr->pcistatus);
    printk("PCIC STATUS %lx\n",tx4925_pcicptr->pcicstatus);
}


extern struct resource pci_io_resource;
extern struct resource pci_mem_resource;
void tx4925_pci_setup(void)
{
    static int called = 0;
    extern unsigned int tx4925_get_mem_size( void );

    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_PCI2, "-\n" );

    mips_memory_upper = tx4925_get_mem_size() << 20;
    mips_memory_upper += KSEG0;
    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_PCI2,
	"0x%08lx=mips_memory_upper\n", mips_memory_upper );
    if (tx4925_memory_upper_max &&
	 mips_memory_upper > tx4925_memory_upper_max) {
	 mips_memory_upper = tx4925_memory_upper_max;
	 printk("limiting memory_upper to 0x%08lx\n", mips_memory_upper);
    }
    mips_pci_io_base = TX4925_PCIIO;
    mips_pci_io_size = TX4925_PCIIO_SIZE;
    mips_pci_mem_base = TX4925_PCIMEM;
    mips_pci_mem_size = TX4925_PCIMEM_SIZE;

    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_PCI2,
	"0x%08lx=mips_pci_io_base\n",	mips_pci_io_base);
    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_PCI2,
	"0x%08lx=mips_pci_io_size\n",	mips_pci_io_size);
    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_PCI2,
	"0x%08lx=mips_pci_mem_base\n",	mips_pci_mem_base);
    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_PCI2,
	"0x%08lx=mips_pci_mem_size\n",	mips_pci_mem_size);
    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_PCI2,
	"0x%08lx=pci_io_resource.start\n",  pci_io_resource.start);
    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_PCI2,
	"0x%08lx=pci_io_resource.end\n",    pci_io_resource.end);
    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_PCI2,
	"0x%08lx=pci_mem_resource.start\n", pci_mem_resource.start);
    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_PCI2,
	"0x%08lx=pci_mem_resource.end\n",   pci_mem_resource.end   );
    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_PCI2,
	"0x%08lx=mips_io_port_base\n",	mips_io_port_base	     );

    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_PCI2,
	"setup pci_io_resource  to 0x%08lx 0x%08lx\n",
	pci_io_resource.start,	 pci_io_resource.end  );
    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_PCI2,
	"setup pci_mem_resource to 0x%08lx 0x%08lx\n",
	pci_mem_resource.start, pci_mem_resource.end );

    if (!called) {
	 printk("TX4925 PCIC -- DID:%04x VID:%04x RID:%02x Arbiter:%s\n",
		 (unsigned short)(tx4925_pcicptr->pciid >> 16),
		 (unsigned short)(tx4925_pcicptr->pciid & 0xffff),
		 (unsigned short)(tx4925_pcicptr->pciccrev & 0xff),
		 (tx4925_ccfgptr->ccfg & TX4925_CCFG_PCIARB) ? "External" : "Internal");
	 called = 1;
    }
    printk("TX4925 PCIC -- PCICLK:");
    printk("Internal(%dMHz)\n", ((BASIL_S1_MASTER_CLOCK * 10) / 6) / 1000000);

    /* GB->PCI mappings */
    tx4925_pcicptr->g2piomask = (TX4925_PCIIO_SIZE - 1);
    tx4925_pcicptr->g2piogbase = TX4925_PCIIO;
    tx4925_pcicptr->g2piopbase = 0;

    tx4925_pcicptr->g2pm0mask = (TX4925_PCIMEM0_SIZE - 1);
    tx4925_pcicptr->g2pm0gbase = TX4925_PCIMEM0;
    tx4925_pcicptr->g2pm0pbase = TX4925_PCIMEM0;

#if defined(TX4925_PCIMEM1) && TX4925_PCIMEM1_SIZE
    tx4925_pcicptr->g2pm1mask = (TX4925_PCIMEM1_SIZE -1);
    tx4925_pcicptr->g2pm1gbase = TX4925_PCIMEM1;
    tx4925_pcicptr->g2pm1pbase = TX4925_PCIMEM1;
#else
    tx4925_pcicptr->g2pm1mask = 0;
    tx4925_pcicptr->g2pm1gbase = 0;
    tx4925_pcicptr->g2pm1pbase = 0;
#endif
#if defined(TX4925_PCIMEM2) && TX4925_PCIMEM2_SIZE
    tx4925_pcicptr->g2pm2mask = (TX4925_PCIMEM2_SIZE - 1);
    tx4925_pcicptr->g2pm2gbase = TX4925_PCIMEM2;
    tx4925_pcicptr->g2pm2pbase = TX4925_PCIMEM2;
#else
    tx4925_pcicptr->g2pm2mask = 0;
    tx4925_pcicptr->g2pm2gbase = 0;
    tx4925_pcicptr->g2pm2pbase = 0;
#endif

    /* PCI->GB mappings (I/O) */
    tx4925_pcicptr->p2giopbase = 0; /* 256B */
    tx4925_pcicptr->p2giogbase = 0;

    tx4925_pcicptr->p2gioctr = 
#ifdef TX4925_SUPPORT_COMMAND_IO
		 TX4925_PCIC_P2GIOCTR_P2GIOEN
#ifdef __BIG_ENDIAN
		 | TX4925_PCIC_P2GIOCTR_BSWAP
#endif
		 ;
#else
		 0;
#endif


    /* PCI->GB mappings (MEMORY) */
    tx4925_pcicptr->p2gm0pbase = 0;
    tx4925_pcicptr->p2gm0gbase = 0;
    tx4925_pcicptr->p2gm0ctr =
		 ((mips_memory_upper - 1) & TX4925_PCIC_P2GMnCTR_AM_MASK)
		 | TX4925_PCIC_P2GMnCTR_TPRBL_8DW
		 | TX4925_PCIC_P2GMnCTR_MEMnPE
		 | TX4925_PCIC_P2GMnCTR_P2GMnEN
#ifdef __BIG_ENDIAN
		 | TX4925_PCIC_P2GMnCTR_BSWAP
#endif
		 ;
    tx4925_pcicptr->p2gm1ctr = 0;
    tx4925_pcicptr->p2gm2ctr = 0;


    /* Enable Initiator Memory 0 Space, I/O Space, Config */
    tx4925_pcicptr->g2pcfg = 
		   TX4925_PCIC_G2PCFG_BSWAPM0
		 | TX4925_PCIC_G2PCFG_BSWAPM1
		 | TX4925_PCIC_G2PCFG_BSWAPM2
		 | TX4925_PCIC_G2PCFG_BSWAPIO
		 | TX4925_PCIC_G2PCFG_G2PM0EN
#if defined(TX4925_PCIMEM1) && TX4925_PCIMEM1_SIZE
		 | TX4925_PCIC_G2PCFG_G2PM1EN
#endif
#if defined(TX4925_PCIMEM2) && TX4925_PCIMEM2_SIZE
		 | TX4925_PCIC_G2PCFG_G2PM2EN
#endif
		 | TX4925_PCIC_G2PCFG_G2PIOEN
	//	 | TX4925_PCIC_G2PCFG_BSWAPI
		 ;
	tx4925_pcicptr->pciccfg =
		(tx4925_pcicptr->pciccfg & TX4925_PCIC_PCICCFG_GBWC_MASK) |
		 TX4925_PCIC_PCICCFG_RESERVE;
	                                                    
	tx4925_pcicptr->pcicfg1 = 0;

    if (tx4925_pcic_trdyto >= 0) {
	 tx4925_pcicptr->g2ptocnt &= ~0xff;
	 tx4925_pcicptr->g2ptocnt |= (tx4925_pcic_trdyto & 0xff);
	 //printk("TX4925 PCIC -- TRDYTO:%02lx\n",
	 //	 tx4925_pcicptr->g2ptocnt & 0xff);
    }

    if (tx4925_pcic_retryto >= 0) {
        tx4925_pcicptr->g2ptocnt &= ~0xff00;
        tx4925_pcicptr->g2ptocnt |= ((tx4925_pcic_retryto<<8) & 0xff00);
    }

    /* Clear All Local Bus Status */
    tx4925_pcicptr->pcicstatus = TX4925_PCIC_PCICSTATUS_ALL;
    /* Enable All Local Bus Interrupts */
    tx4925_pcicptr->pcicmask = TX4925_PCIC_PCICSTATUS_ALL;
    /* Clear All Initiator Status */
    tx4925_pcicptr->g2pstatus = TX4925_PCIC_G2PSTATUS_ALL;
    /* Enable All Initiator Interrupts */
    tx4925_pcicptr->g2pmask = TX4925_PCIC_G2PSTATUS_ALL;
    tx4925_pcicptr->g2pmask &= ~TX4925_PCIC_G2PSTATUS_MDFE;
    /* Clear All PCI Status Error */
    tx4925_pcicptr->pcistatus =
		 (tx4925_pcicptr->pcistatus & 0x0000ffff) |
		 (TX4925_PCIC_PCISTATUS_ALL << 16);
    /* Enable All PCI Status Error Interrupts */
    tx4925_pcicptr->pcimask = TX4925_PCIC_PCISTATUS_ALL;

    /* PCIC Int => IRC IRQ */
    tx4925_pcicptr->pcicfg2 =
		 (tx4925_pcicptr->pcicfg2 & 0xffffff00) |
		 TX4925_IRQ_IRC_PCIC;

    if (tx4925_ccfgptr->ccfg & TX4925_CCFG_PCIARB) {
	 /* XXX */
    } else {
	 /* Reset Bus Arbiter */
	 tx4925_pcicptr->pbacfg = TX4925_PCIC_PBACFG_RPBA;
	 /* Enable Bus Arbiter */
	 tx4925_pcicptr->pbacfg = TX4925_PCIC_PBACFG_PBAEN;
    }

    tx4925_pcicptr->pcistatus =
		 PCI_COMMAND_MASTER |
		 PCI_COMMAND_MEMORY |
#ifdef TX4925_SUPPORT_COMMAND_IO
		 PCI_COMMAND_IO |
#endif
		 PCI_COMMAND_PARITY | PCI_COMMAND_SERR;

    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_PCI2, ":pci setup complete:\n" );
    /* tx4925_dump_pcic_settings(); */

    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_PCI2, "+\n" );
    return;
}

#endif /* CONFIG_PCI */


void 
basil_s1_restart( char *command )
{
    printk(KERN_NOTICE "System Rebooting...\n");

    flush_cache_all();
    write_c0_wired(0);
    __asm__ __volatile__("jr\t%0"::"r"(0xbfc00000));
    /* no return */
}


void 
basil_s1_halt( void )
{
    printk(KERN_NOTICE "System Halted\n");
    cli();
    while ( 1 ) 
	 {
	 asm_wait();
	 }
    /* no return */
}


void 
basil_s1_power_off( void )
{
    basil_s1_halt();
    /* no return */
}


void __init
basil_s1_setup( void )
{

    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_SETUP, "-\n" );

    set_io_port_base((KSEG1 + TX4925_PCIIO));
    isa_slot_offset = (unsigned long)(KSEG1 + TX4925_PCIIO);

    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_SETUP, ":mips_io_port_base=0x%08lx\n", mips_io_port_base );

    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_SETUP, ":Resource\n" );
    ioport_resource.start = 0;
    ioport_resource.end = 0xffffffff;
    iomem_resource.start = 0;
    iomem_resource.end = 0xffffffff;


    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_SETUP, ":ResetRoutines\n" );
    _machine_restart	= basil_s1_restart;
    _machine_halt	= basil_s1_halt;
    _machine_power_off	= basil_s1_power_off;


    #ifdef CONFIG_FB
    {
    conswitchp = &dummy_con;
    }
    #endif


#ifdef CONFIG_PCI

    /* PCIC */
    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_PCI1, 
	   "PCI mode is %lx, pci arb is %lx\n", 
	   (unsigned long)tx4925_ccfgptr->ccfg & TX4925_CCFG_PCIMODE, 
	   (unsigned long)tx4925_ccfgptr->ccfg & TX4925_CCFG_PCIARB ); 

    /* CCFG */
    /* enable Timeout BusError */
    if (tx4925_ccfg_toeon)
	 tx4925_ccfgptr->ccfg |= TX4925_CONFIG_CCFG_TOE;

    tx4925_pci_setup();
#endif

#if 1	 /* for controll PCICLK2 */
    /* check board connection */
    if (!MODEM_DCT) {
	unsigned int val;

	/* connected option board */
	printk("Connected option board.\n");

	/* enable PCICLK2 */
	val = TX4925_RD(TX4925_MKA(TX4925_CONFIG_PCFG)) | 0x10000000;
	TX4925_WR(TX4925_MKA(TX4925_CONFIG_PCFG), val);

	/* set MODEM_RST to one */
	MODEM_RST_RESET;
	mdelay(500);
	MODEM_RST_NORMAL;


	mdelay(300);

	/* Type 0 configuration */
	tx4925_pcicptr->g2pcfgadrs = (0x00 << 0x10) |
				      (PCI_DEVFN(0x02, 0) << 0x08) |
				      (PCI_VENDOR_ID & 0xfc);

	/* clear M_ABORT and Disable M_ABORT Int. */
	tx4925_pcicptr->pcistatus =
		(tx4925_pcicptr->pcistatus & 0x0000ffff) |
		(PCI_STATUS_REC_MASTER_ABORT << 16);
	tx4925_pcicptr->pcimask &= ~PCI_STATUS_REC_MASTER_ABORT;
	tx4925_pcicptr->g2pmask &= ~(1 << 6);

	mdelay(5);

	val = tx4925_pcicptr->g2pcfgdata;

	/* check master abort */
	if (tx4925_pcicptr->pcistatus & (PCI_STATUS_REC_MASTER_ABORT << 16)) {
	    tx4925_pcicptr->pcistatus =
			 (tx4925_pcicptr->pcistatus & 0x0000ffff) |
			 (PCI_STATUS_REC_MASTER_ABORT << 16);
	     tx4925_pcicptr->g2pstatus = (1 << 6);

	     printk("PCI Master Abort occasion -> Not connected PCI device\n");
	     /* disable PCICLK2 */
	     val = TX4925_RD(TX4925_MKA(TX4925_CONFIG_PCFG)) & 0xEFFFFFFF;
	     TX4925_WR(TX4925_MKA(TX4925_CONFIG_PCFG), val);
	 } else {
	     if (val != 0x04761180) {
		 /* disable PCICLK2 */
		 printk("disable PCICLK2(not Cardbus Bridge(%08x)\n", val);
		 val = TX4925_RD(TX4925_MKA(TX4925_CONFIG_PCFG)) & 0xEFFFFFFF;
		 TX4925_WR(TX4925_MKA(TX4925_CONFIG_PCFG), val);
	     }
	 }
	 tx4925_pcicptr->pcimask |= PCI_STATUS_REC_MASTER_ABORT;
	 tx4925_pcicptr->g2pmask |= (1 << 6);
    } else {
	 /* not connected option board */
	 printk("Not connected option board.\n");
    }
#endif

    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_SETUP, "+\n" );
    return;
}


extern rwlock_t xtime_lock;
/* last time when xtime and rtc are sync'ed up */
static long last_rtc_update;

static void
(*system_timer_interrupt)(int irq, void * dev_id, struct pt_regs * regs) = NULL;
static void
basil_s1_timer_interrupt(int irq, void * dev_id, struct pt_regs * regs)
{
    /* Acknowledge and reset the interrupt */
    TX4925_WR(TX4925_MKA(TX4925_TMR0_TMTISR0), 0);

    if (system_timer_interrupt) {
	(*system_timer_interrupt)(irq, dev_id, regs);
    } else {


	if(!user_mode(regs)) {
	     if (prof_buffer && current->pid) {
		 extern int _stext;
		 unsigned long pc = regs->cp0_epc;

		 pc -= (unsigned long) & _stext;
		 pc >>= prof_shift;
		 /*
		  * Dont ignore out-of bounds pc values silently,
		  * put them into the last histogram slot, so if
		  * present, they will show up as a sharp peak.
		  */
		 if (pc > prof_len-1)
		     pc = prof_len-1;
		 atomic_inc((atomic_t *)&prof_buffer[pc]);
	     }
	}

	/*
	 * call the generic timer interrupt handling
	 */
	do_timer(regs);

	/*
	 * If we have an externally synchronized Linux clock, then update
	 * CMOS clock accordingly every ~11 minutes. rtc_set_time() has to be
	 * called as close as possible to 500 ms before the new second starts.
	 */
	read_lock (&xtime_lock);
	if ((time_status & STA_UNSYNC) == 0 &&
	     xtime.tv_sec > last_rtc_update + 660 &&
	     xtime.tv_usec >= 500000 - ((unsigned) tick) / 2 &&
	     xtime.tv_usec <= 500000 + ((unsigned) tick) / 2) {
	     if (rtc_set_time(xtime.tv_sec) == 0) {
		 last_rtc_update = xtime.tv_sec;
	     } else {
		 last_rtc_update = xtime.tv_sec - 600; 
		 /* do it again in 60 s */
	     }
	}
	read_unlock (&xtime_lock);

    }
}

void __init
basil_s1_time_init( void )
{
    extern void rtc_rx5c348_init(void);
    u32  temp;

    rtc_rx5c348_init();

    /* Tx4925 TMR 0 Init */
    TX4925_WR(TX4925_MKA(TX4925_TMR0_TMTCR0),
	( TX4925_TMR_TMTCR_CCDE | TX4925_TMR_TMTCR_CRE
	| TX4925_TMR_TMTCR_CCS_IMBUS | TX4925_TMR_TMTCR_TMODE_INTVL));
    TX4925_WR(TX4925_MKA(TX4925_TMR0_TMTISR0), 0);
    TX4925_WR(TX4925_MKA(TX4925_TMR0_TMCCDR0), 0);		 /* Div 2 */
    temp = (BASIL_S1_MASTER_CLOCK * 4 / 2);	 /* IMBUSCLK */
    temp = (temp / 2) / HZ;

    TX4925_WR(TX4925_MKA(TX4925_TMR0_TMCPRA0), temp);

    mips_counter_frequency = BASIL_S1_MASTER_CLOCK * 10;
    /* round to 1/10th of a MHz */
    mips_counter_frequency /= ( 100 * 1000 );
    mips_counter_frequency *= ( 100 * 1000 );
    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_INFO, ":mips_counter_frequency=%uHz (%uMHz)\n", 
      mips_counter_frequency, mips_counter_frequency/1000000 );

    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_TIME_INIT, "+\n" );
    return;
}


void __init
basil_s1_timer_setup( struct irqaction *irq )
{
    unsigned long  temp;

    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_TIMER_SETUP, "-\n" );
    if (irq->handler) {
	system_timer_interrupt = irq->handler;
	BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_TIMER_SETUP, "chain interrupt(%p)\n", irq->handler );
    }
    irq->handler = &basil_s1_timer_interrupt;
    setup_irq(TX4925_IRQ_IRC_TMR0, irq);

    /* Enable Interrupt */
    temp = (TX4925_TMR_TMITMRn_TIIE | TX4925_TMR_TMITMRn_TZCE);
    TX4925_WR(TX4925_MKA(TX4925_TMR0_TMITMR0), temp);

    /* Start Counter */
    temp = TX4925_RD(TX4925_MKA(TX4925_TMR0_TMTCR0)) ;
    temp &= ~(TX4925_TMR_TMTCR_TCE | TX4925_TMR_TMTCR_CRE);
    TX4925_WR(TX4925_MKA(TX4925_TMR0_TMTCR0), temp);
    TX4925_WR(TX4925_MKA(TX4925_TMR0_TMTCR0), (temp | TX4925_TMR_TMTCR_TCE));

    BASIL_S1_SETUP_DPRINTK( BASIL_S1_SETUP_TIMER_SETUP, "+\n" );
    return;
}
