#include <linux/config.h>
#include <linux/types.h>
#include <asm/tx4925/basil_s1/basil_s1.h>

#if defined(CONFIG_REMOTE_DEBUG)

typedef unsigned char uint8;
typedef unsigned int uint32;

#define BASE		BASIL_S1_DEBUG_IF
#define TX		0
#define RX		0
#define	DLLO		0
#define	DLHI		1
#define	IENB		1
#define	IID		2
#define	FCR		2
#define	LINECTL		3
#define MODCTL		4
#define	LSTAT		5
#define	MODSTAT		6
#define	SCRATCH		7

#define UART_GETREG(x, dp, reg) \
	x = *((volatile unsigned char *)(dp + (reg * 4)))
#define UART_PUTREG(x, dp, reg) \
	*((volatile unsigned char *)(dp + (reg * 4))) = x

#define	BAUD_2400	2400
#define	BAUD_4800	4800
#define	BAUD_9600	9600
#define	BAUD_19200	19200
#define	BAUD_38400	38400
#define	BAUD_57600	57600
#define	BAUD_115200	115200

#define	PARITY_NONE	0
#define	PARITY_ODD	0x08
#define	PARITY_EVEN	0x18
#define	PARITY_MARK	0x28
#define	PARITY_SPACE	0x38

#define	DATA_5BIT	0x0
#define	DATA_6BIT	0x1
#define	DATA_7BIT	0x2
#define	DATA_8BIT	0x3

#define	STOP_1BIT	0x0
#define	STOP_2BIT	0x4

static void basil_s1_debugInit(uint32 baud, uint8 data, uint8 parity, uint8 stop)
{
    /* disable interrupts */
    UART_PUTREG(0, BASE, IENB);

    /* set up baud rate */
    {
        uint32 divisor;
        /* set DIAB bit */
        UART_PUTREG(0x80, BASE, LINECTL);
        /* set divisor */
        divisor = (BASIL_S1_DEBUG_IF_CLOCK + baud * 8) / (baud * 16);
        UART_PUTREG((divisor & 0xFF), BASE, DLLO);
        UART_PUTREG(((divisor >> 8) & 0xFF), BASE, DLHI);
        /* clear DIAB bit */
        UART_PUTREG(0, BASE, LINECTL);
    }
    /* set data format */
    UART_PUTREG((data | parity | stop), BASE, LINECTL);
}

static int remoteDebugInitialized = 0;

uint8 basil_s1_getDebugChar(void)
{
    uint8  lsr_reg, c;

    if (!remoteDebugInitialized) {
        remoteDebugInitialized = 1;
        basil_s1_debugInit(BAUD_38400, DATA_8BIT, PARITY_NONE, STOP_1BIT);
    }
    do {
        UART_GETREG(lsr_reg, BASE, LSTAT);
    } while ((lsr_reg & 0x1) == 0);
    UART_GETREG(c, BASE, RX);
    return(c);
}

uint8 basil_s1_putDebugChar(uint8 byte)
{
    uint8  lsr_reg;

    if (!remoteDebugInitialized) {
        remoteDebugInitialized = 1;
        basil_s1_debugInit(BAUD_38400, DATA_8BIT, PARITY_NONE, STOP_1BIT);
    }
    do {
        UART_GETREG(lsr_reg, BASE, LSTAT);
    } while ((lsr_reg & 0x20) == 0);
    UART_PUTREG(byte, BASE, TX);
    return 1;
}

#endif

