#include <linux/config.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/mm.h>
#include <linux/swap.h>
#include <linux/ioport.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/pci.h>
#include <linux/timex.h>
#include <asm/bootinfo.h>
#include <asm/page.h>
#include <asm/bootinfo.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/pci.h>
#include <asm/processor.h>
#include <asm/ptrace.h>
#include <asm/reboot.h>
#include <asm/time.h>
#include <linux/version.h>
#include <linux/bootmem.h>
#include <linux/blk.h>
#include <asm/tx4925/tx4925.h>
#include <asm/tx4925/basil_s1/basil_s1.h>

#if defined(CONFIG_BRINGUP_RAW_SERIAL_IO)

#define BASE		BASIL_S1_DEBUG_IF
#define TX		0
#define	LSTAT		5

#define UART_GETREG(x, dp, reg) \
	x = *((volatile unsigned char *)(dp + (reg * 4)))
#define UART_PUTREG(x, dp, reg) \
	*((volatile unsigned char *)(dp + (reg * 4))) = x

void basil_s1_bringup_printk_raw_serial_io_putc(unsigned char byte)
{
    unsigned char  lsr_reg;

    do {
        UART_GETREG(lsr_reg, BASE, LSTAT);
    } while ((lsr_reg & 0x20) == 0);

    UART_PUTREG(byte, BASE, TX);

    do {
        UART_GETREG(lsr_reg, BASE, LSTAT);
    } while ((lsr_reg & 0x20) == 0);

}
#endif
