/*
 *
 * BRIEF MODULE DESCRIPTION
 *	Board specific pci fixups.
 *
 * Author: Steve Longerbeam <stevel@mvista.com, or source@mvista.com>
 *
 * 2001 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#include <linux/config.h>

#ifdef CONFIG_PCI

#include <linux/types.h>
#include <linux/pci.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <asm/rc32434/rc32434.h>
#include <asm/rc32434/pci.h>
#include <asm/rc32434/pcikorina.h>

void __init
pcibios_fixup_resources(struct pci_dev *dev)
{
}

void __init
pcibios_fixup(void)
{

}

void __init
pcibios_fixup_irqs(void)
{
	struct pci_dev *dev;

	pci_for_each_dev(dev) {
		unsigned int slot;
		if (dev->bus->number != 0) {
			return;
		}

		slot = PCI_SLOT(dev->devfn);

		if (slot > 0 && slot <= 5) {
			unsigned char pin;
			pci_read_config_byte(dev, PCI_INTERRUPT_PIN, &pin);

			switch (pin) {
			case 1:	/* INTA */
				/* dev->irq = 84; */
				dev->irq = GROUP4_IRQ_BASE + 11;
				break;
			case 2:	/* INTB */
				/* dev->irq = 84; */
				dev->irq = GROUP4_IRQ_BASE + 11;
				break;
			case 3:	/* INTC */
				/* dev->irq = 84; */
				dev->irq = GROUP4_IRQ_BASE + 11;
				break;
			case 4:	/* INTD */
				/* dev->irq = 84; */
				dev->irq = GROUP4_IRQ_BASE + 11;
				break;
			default:
				dev->irq = 0xff;
				break;
			}
#ifdef DEBUG
			printk("irq fixup: slot %d, pin %d, irq %d\n",
			       slot, pin, dev->irq);
#endif
			pci_write_config_byte(dev, PCI_INTERRUPT_LINE,
					      dev->irq);
		}
	}

}
#endif
