/*
 *
 * BRIEF MODULE DESCRIPTION
 *	RC32300 reset routines.
 *
 * Author: Steve Longerbeam <stevel@mvista.com, or source@mvista.com>
 *
 * 2001 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */

#include <linux/sched.h>
#include <linux/mm.h>
#include <asm/io.h>
#include <asm/pgtable.h>
#include <asm/processor.h>
#include <asm/reboot.h>
#include <asm/system.h>
#include <asm/rc32300/rc32300.h>

void (*__wbflush)(void);
void rc32300_wbflush(void)
{
        __asm__ volatile ("sync");
}

void rc32300_restart(char *command)
{
	set_c0_status((ST0_BEV | ST0_ERL));
	set_c0_config(CONF_CM_UNCACHED);
	flush_cache_all();
	write_c0_wired(0);

#ifdef CONFIG_MIPS_RC32334
	// Trigger the WatchDog Timer (Timer 3) to warm reset
	rc32300_writel(0, TIMER0_CNTL + 3*TIMER_REG_OFFSET);
	rc32300_writel(0xd8, CPU_IP_BUSERR_CNTL);
	rc32300_writel(0, TIMER0_COUNT + 3*TIMER_REG_OFFSET);
	rc32300_writel(2, TIMER0_COMPARE + 3*TIMER_REG_OFFSET);
	rc32300_writel(1, TIMER0_CNTL + 3*TIMER_REG_OFFSET);
#elif defined (CONFIG_MIPS_RC32355)
	rc32300_writel(0x80000001, RESET_CNTL);
#else
	__asm__ __volatile__("jr\t%0"::"r"(0xbfc00000));
#endif
}

void rc32300_halt(void)
{
	printk(KERN_NOTICE "\n** You can safely turn off the power\n");
	while (1)
		__asm__(".set\tmips3\n\t"
	                "wait\n\t"
			".set\tmips0");
}

void rc32300_power_off(void)
{
	rc32300_halt();
}
