/*
 * BRIEF MODULE DESCRIPTION
 *	IDT 79EB355/79RP355 board setup.
 *
 * Author: Steve Longerbeam <stevel@mvista.com, or source@mvista.com>
 *
 * 2002 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#include <linux/config.h>
#include <linux/init.h>
#include <linux/mm.h>
#include <linux/sched.h>
#include <linux/irq.h>
#include <linux/ioport.h>
#include <asm/bootinfo.h>
#include <asm/io.h>
#include <asm/mipsregs.h>
#include <asm/pgtable.h>
#include <asm/reboot.h>
#include <asm/rc32300/rc32300.h>

extern void (*board_time_init)(void);
extern void (*board_timer_setup)(struct irqaction *irq);
extern void rc32300_time_init(void);
extern void rc32300_timer_setup(struct irqaction *irq);
extern char * __init prom_getcmdline(void);

extern void rc32300_restart(char *);
extern void rc32300_halt(void);
extern void rc32300_power_off(void);

#ifdef CONFIG_IDT_79EB355
extern int init_lcd(void);
#endif

#ifdef CONFIG_BLK_DEV_INITRD
extern unsigned long initrd_start, initrd_end;
extern void * __rd_start, * __rd_end;
#endif

#if 0
static void dump_dev(int devnum)
{
	printk("DEV%d_BASE   = %08x\n", devnum,
	       rc32300_readl(DEV0_BASE + devnum*DEV_REG_OFFSET));
	printk("DEV%d_MASK   = %08x\n", devnum,
	       rc32300_readl(DEV0_MASK + devnum*DEV_REG_OFFSET));
	printk("DEV%d_CNTL   = %08x\n", devnum,
	       rc32300_readl(DEV0_CNTL + devnum*DEV_REG_OFFSET));
	printk("DEV%d_TIMING = %08x\n", devnum,
	       rc32300_readl(DEV0_TIMING + devnum*DEV_REG_OFFSET));
}
#endif


void __init idt_setup(void)
{
	char* argptr;
	
	argptr = prom_getcmdline();
#ifdef CONFIG_SERIAL_CONSOLE
	if ((argptr = strstr(argptr, "console=")) == NULL) {
		argptr = prom_getcmdline();
		strcat(argptr, " console=ttyS0,9600");
	}
#endif

	board_time_init = rc32300_time_init;
	board_timer_setup = rc32300_timer_setup;

	_machine_restart = rc32300_restart;
	_machine_halt = rc32300_halt;
	_machine_power_off = rc32300_power_off;

	set_io_port_base(KSEG1);

	// clear out any wired entries
	write_c0_wired(0);

#ifdef CONFIG_IDT_79EB355
	/*
	 * Setup Device 3. The EPLD (U13) splits device 3 chip-select
	 * into seperate chip selects for the TDM, LCD, and RTC
	 * devices.
	 */
	rc32300_writel(0x00000000, DEV0_MASK   + 3*DEV_REG_OFFSET);
	rc32300_writel(TDM_BASE,   DEV0_BASE   + 3*DEV_REG_OFFSET);
	/* timings are from IDT/sim source */
	rc32300_writel(0x0FFFFF84, DEV0_CNTL   + 3*DEV_REG_OFFSET);
	rc32300_writel(0x00001FFF, DEV0_TIMING + 3*DEV_REG_OFFSET);
	rc32300_writel(0xFFFF0000, DEV0_MASK   + 3*DEV_REG_OFFSET);
	
	/* initialize the LCD panel */
	init_lcd();

	idtprintf("IDT 79EB355 Eval MVL 2.1");

#ifdef CONFIG_MTD
	/*
	 * setup device 2 for flash devices. Set for
	 * 32-bit databus size, write-enable.
	 */
	rc32300_writel(0x00000000, DEV0_MASK   + 2*DEV_REG_OFFSET);
	rc32300_writel(FLASH_BASE, DEV0_BASE   + 2*DEV_REG_OFFSET);
	/* timings are from IDT/sim source */
	rc32300_writel(0x03CF3316, DEV0_CNTL   + 2*DEV_REG_OFFSET);
	rc32300_writel(0x00001133, DEV0_TIMING + 2*DEV_REG_OFFSET);
	rc32300_writel(0xFF800000, DEV0_MASK   + 2*DEV_REG_OFFSET);
#endif
#endif // CONFIG_IDT_79EB355

#ifdef CONFIG_BLK_DEV_INITRD
	ROOT_DEV = MKDEV(RAMDISK_MAJOR, 0);
	initrd_start = (unsigned long)&__rd_start;
	initrd_end = (unsigned long)&__rd_end;
#endif
}
