/*
 * Copyright 2002 Momentum Computer Inc.
 * Author: Matthew Dharm <mdharm@momenco.com> 
 *
 * Copyright 2004 PMC-Sierra
 * Author: Manish Lachwani (lachwani@pmc-sierra.com)
 *
 * Based on work for the Linux port to the Ocelot board, which is
 * Copyright 2001 MontaVista Software Inc.
 * Author: Jun Sun, jsun@mvista.com or jsun@junsun.net
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 *
 * Ocelot-III changes: Ocelot-III board has been built with both the Rm7065C and
 * the Rm7900 - Manish Lachwani (lachwani@pmc-sierra.com)
 */
#include <linux/types.h>
#include <linux/pci.h>
#include <linux/kernel.h>
#include <linux/version.h>
#include <linux/init.h>
#include <asm/pci.h>


void __init pcibios_fixup_irqs(void)
{
	struct pci_bus *current_bus;
	struct pci_dev *devices;

	/* loop over all known devices on this bus */
	pci_for_each_dev(devices) {
		/*
		 *  PCI IRQ routing on the Ocelot-3 board
		 */
		current_bus = devices->bus;

		if (current_bus->parent != NULL) {
			panic("Subordinate busses not supported");
		}

		if ((current_bus->number == 0) &&
			(PCI_SLOT(devices->devfn) == 1)) {
			devices->irq = 3;
		} else if ((current_bus->number == 0) &&
			(PCI_SLOT(devices->devfn) == 2)) {
			devices->irq = 4;
		} else if ((current_bus->number == 1) &&
			(PCI_SLOT(devices->devfn) == 1)) {
			devices->irq = 5;
		} else if ((current_bus->number == 1) &&
			(PCI_SLOT(devices->devfn) == 2)) {
			devices->irq = 6;
		} else {
			/* We don't have assign interrupts for other devices */
			devices->irq = 0xff;
		}

		/* Assign an interrupt number for the device */
		current_bus->ops->write_byte(devices, PCI_INTERRUPT_LINE, devices->irq);
	}
}
