/*
 * Copyright 2001 MontaVista Software Inc.
 *
 * Author: source@mvista.com
 *
 * RTC routines for Dallas chip.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation 
 *
 * 2001-2003 (c) MontaVista Software, Inc. This file is licensed under the
 * terms of the GNU General Public License version 2. This program is
 * licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#include <asm/mc146818rtc.h>	/* bad name... */
#include <asm/jmr3927/jmr3927.h>

static unsigned char jmr3927_rtc_read_data(unsigned long addr)
{
	return jmr3927_nvram_in(addr);
}

static void jmr3927_rtc_write_data(unsigned char data, unsigned long addr)
{
	jmr3927_nvram_out(data, addr);
}

static int jmr3927_rtc_bcd_mode(void)
{
	return 1;
}

struct rtc_ops jmr3927_rtc_ops = {
	&jmr3927_rtc_read_data,
	&jmr3927_rtc_write_data,
	&jmr3927_rtc_bcd_mode
};
