/* $Id: kbd.c,v 1.2 2002/07/11 22:23:15 ahennessy Exp $
 *
 * Author: source@mvista.com
 *
 * Based on arch/mips/lib/kbd-std.c
 *
 * Copyright (C) 2000-2001 Toshiba Corporation 
 *
 * 2001-2003 (c) MontaVista Software, Inc. This file is licensed under the
 * terms of the GNU General Public License version 2. This program is
 * licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */

#include <linux/ioport.h>
#include <linux/sched.h>
#include <linux/pc_keyb.h>
#include <asm/keyboard.h>
#include <asm/io.h>
#include <asm/jmr3927/jmr3927.h>

#ifdef DEBUG
#undef DEBUG
#endif

#ifdef DEBUG 
#define PRINTD(args...) printk(KERN_WARNING __FUNCTION__"():"args);
#else
#define PRINTD(args...)
#endif

#define KEYBOARD_IRQ	JMR3927_IRQ_ISAC_IRQKB
#define AUX_IRQ	JMR3927_IRQ_ISAC_IRQMOUSE
#define JMR_KBD_DATA_REG	JMR3927_KBD_PORT
#define JMR_KBD_STATUS_REG	(JMR3927_KBD_PORT+4)
#define JMR_KBD_CNTL_REG	(JMR3927_KBD_PORT+4)

#ifdef JMR3927_INIT_INDIRECT_PCI
/* mips_io_port_base is set to JMR3927_PORT_BASE */
#define jk_inb(x) inb(x)
#define jk_outb(x,y) outb(x,y)
#else
/* 
   This is a makeshift for JMR-TX3927(2001/10/29).
   mips_io_port_base has been changed for PCI control.
   Therefore inb/outb cannot access correct address.
   NOTE:
   This code strongly assumes that
   mips_io_port_base is set to JMR3927_PORT_BASE + JMR3927_PCIIO.
   (see linux/arch/mips/tx3927/jmr3927/setup.c)
*/
/* mips_io_port_base is set to JMR3927_PORT_BASE + JMR3927_PCIIO;*/
#define jk_inb(x) inb(x - JMR3927_PCIIO);
#define jk_outb(x,y ) outb(x,y - JMR3927_PCIIO);
#endif

static void jmr_kbd_request_region(void)
{
	request_region(JMR3927_KBD_PORT, 16, "keyboard");
}

static int jmr_kbd_request_irq(void (*handler)(int, void *, struct pt_regs *))
{
	return request_irq(KEYBOARD_IRQ, handler, 0, "keyboard", NULL);
}

static int jmr_aux_request_irq(void (*handler)(int, void *, struct pt_regs *))
{
	return request_irq(AUX_IRQ, handler, 0, "PS/2 Mouse", NULL);
}

static void jmr_aux_free_irq(void)
{
	free_irq(AUX_IRQ, NULL);
}

static unsigned char jmr_kbd_read_input(void)
{
	unsigned char c;
	c = jk_inb(JMR_KBD_DATA_REG);
	return c;
}

static void jmr_kbd_write_output(unsigned char val)
{
	int status;

	do {
		status = jk_inb(JMR_KBD_CNTL_REG);
	} while (status & KBD_STAT_IBF);
	jk_outb(val, JMR_KBD_DATA_REG);
}

static void jmr_kbd_write_command(unsigned char val)
{
	int status;

	do {
		status = jk_inb(JMR_KBD_CNTL_REG);
	} while (status & KBD_STAT_IBF);
	jk_outb(val, JMR_KBD_CNTL_REG);
}

static unsigned char jmr_kbd_read_status(void)
{
	return jk_inb(JMR_KBD_STATUS_REG);
}

struct kbd_ops jmr3927_kbd_ops = {
	jmr_kbd_request_region,
	jmr_kbd_request_irq,

	jmr_aux_request_irq,
	jmr_aux_free_irq,

	jmr_kbd_read_input,
	jmr_kbd_write_output,
	jmr_kbd_write_command,
	jmr_kbd_read_status
};
