/*
 * Copyright 2001 MontaVista Software Inc.
 *
 * Author: source@mvista.com
 *
 * Based on arch/mips/tsdb/kernel/int-handler.S
 *
 * Copyright (C) 2000-2001 Toshiba Corporation 
 *
 * 2001-2003 (c) MontaVista Software, Inc. This file is licensed under the
 * terms of the GNU General Public License version 2. This program is
 * licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */

#include <asm/asm.h>
#include <asm/mipsregs.h>
#include <asm/regdef.h>
#include <asm/stackframe.h>
#include <asm/jmr3927/jmr3927.h>

	/* A lot of complication here is taken away because:
	 *
	 * 1) We handle one interrupt and return, sitting in a loop
	 *    and moving across all the pending IRQ bits in the cause
	 *    register is _NOT_ the answer, the common case is one
	 *    pending IRQ so optimize in that direction.
	 *
	 * 2) We need not check against bits in the status register
	 *    IRQ mask, that would make this routine slow as hell.
	 *
	 * 3) Linux only thinks in terms of all IRQs on or all IRQs
	 *    off, nothing in between like BSD spl() brain-damage.
	 *
	 */

/* Flush write buffer (needed?)
 * NOTE: TX39xx performs "non-blocking load", so explicitly use the target
 * register of LBU to flush immediately.
 */
#define FLUSH_WB(tmp)	\
	la	tmp, JMR3927_IOC_REV_ADDR; \
	lbu	tmp, (tmp); \
	move	tmp, zero;

	.text
	.set	noreorder
	.set	noat
	.align	5
	NESTED(jmr3927_IRQ, PT_SIZE, sp)
	SAVE_ALL
	CLI
	.set	at
	jal	jmr3927_irc_irqdispatch
	 move	a0, sp
	FLUSH_WB(t0)
	j	ret_from_irq
	 nop
	END(jmr3927_IRQ)
