/***********************************************************************
 *
 * Copyright 2001 MontaVista Software Inc.
 *
 * Author: source@mvista.com
 *
 * arch/mips/jmr3927/common/init.c
 *
 * Copyright (C) 2000-2001 Toshiba Corporation 
 *
 * 2001-2003 (c) MontaVista Software, Inc. This file is licensed under the
 * terms of the GNU General Public License version 2. This program is
 * licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#include <linux/config.h>
#include <linux/init.h>
#include <linux/mm.h>
#include <linux/sched.h>
#include <linux/bootmem.h>

#include <asm/addrspace.h>
#include <asm/bootinfo.h>
#include <asm/mipsregs.h>
#include <asm/jmr3927/jmr3927.h>

int prom_argc;
char **prom_argv, **prom_envp;
extern void  __init prom_init_cmdline(void);
extern char *prom_getenv(char *envname);
unsigned long mips_nofpu = 0;

const char *get_system_type(void)
{
	return "Toshiba"
#ifdef CONFIG_TOSHIBA_JMR3927
	       " JMR_TX3927"
#endif
	;
}

extern void puts(unsigned char *cp);
int __init prom_init(int argc, char **argv, char **envp, int *prom_vec)
{
#ifdef CONFIG_TOSHIBA_JMR3927
	/* CCFG */
	if ((tx3927_ccfgptr->ccfg & TX3927_CCFG_TLBOFF) == 0)
		puts("Warning: TX3927 TLB off\n");
#endif
	prom_argc = argc;
	prom_argv = argv;
	prom_envp = envp;

	mips_machgroup = MACH_GROUP_TOSHIBA;

#ifdef CONFIG_TOSHIBA_JMR3927
	mips_machtype = MACH_TOSHIBA_JMR3927;
#endif

	prom_init_cmdline();
	add_memory_region(0, JMR3927_SDRAM_SIZE, BOOT_MEM_RAM);
	return 0;
}
