/*
 * Carsten Langgaard, carstenl@mips.com
 * Copyright (C) 1999,2000 MIPS Technologies, Inc.  All rights reserved.
 *
 * ########################################################################
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ########################################################################
 *
 * Setting up the clock on the MIPS boards.
 *
 */

#include <linux/types.h>
#include <linux/config.h>
#include <linux/init.h>
#include <linux/kernel_stat.h>
#include <linux/sched.h>
#include <linux/spinlock.h>

#include <asm/mipsregs.h>
#include <asm/ptrace.h>
#include <asm/hardirq.h>
#include <asm/div64.h>
#include <asm/cpu.h>
#include <asm/time.h>

#include <linux/interrupt.h>
#include <linux/timex.h>

#include <asm/intrinsity/fastmath.h>

static unsigned int r4k_offset;	/* Amount to increment compare reg each time */
static unsigned int r4k_cur;	/* What counter should be at next timer irq */

extern unsigned int mips_counter_frequency;

/* 
 * Figure out the r4k offset, the amount to increment the compare
 * register for each time tick. 
 * Use the GPIO count register to calculate offset.
 */
static unsigned int __init cal_r4koff(void)
{
	unsigned int flags;

	__save_and_cli(flags);

	FPGA(CONFIG) &= ~FM_FPGA_COUNT_ENB;
	fm_sync();		/* disable counter interrupts */
	FPGA(CONFIG) &= ~FM_FPGA_COUNT_START;
	fm_sync();		/* stop counter */
	FPGA(CONFIG) |= FM_FPGA_COUNT_RESET;
	fm_sync();		/* clear possible previous interrupt */
	FPGA(COUNT) = FM_FPGA_XTAL_FREQ;
	fm_sync();		/* one seconds worth */

	/* Start r4k counter. */
	write_c0_count(0);

	FPGA(CONFIG) |= FM_FPGA_COUNT_START;
	fm_sync();		/* start counter */

	/* wait for counter to set pending interrupt flag */
	while ((FPGA(STATUS) & FM_FPGA_COUNT_INT) == 0) ;

	/* read elapsed r4k counter */
	mips_counter_frequency = read_c0_count();

	FPGA(CONFIG) &= ~FM_FPGA_COUNT_START;
	fm_sync();		/* stop counter */
	FPGA(CONFIG) |= FM_FPGA_COUNT_RESET;
	fm_sync();		/* clear possible previous interrupt */

	/* restore interrupts */
	__restore_flags(flags);

	return (mips_counter_frequency / HZ);
}

void __init fm_time_init(void)
{
	unsigned int est_freq, flags;

	__save_and_cli(flags);

	r4k_offset = cal_r4koff();
	est_freq = r4k_offset * HZ;

	est_freq += 5000;	/* round */
	est_freq -= est_freq % 10000;
	printk("CPU frequency %d.%02d MHz\n", est_freq / 1000000,
	       (est_freq % 1000000) * 100 / 1000000);

	__restore_flags(flags);
}

void __init fm_timer_setup(struct irqaction *irq)
{
	/* we are using the cpu counter for timer interrupts */
	/* We use ll_timer_interrupt() to bypass do_IRQ() */
	irq->handler = no_action;
	setup_irq(FM_IRQ_TIMER, irq);
}
