/*
 * arch/mips/intrinsity/common/setup.c
 *
 * Intrinsity FastMATH - specific Intrinsity setup.
 *
 * Author: MontaVista Software, Inc. <source@mvista.com>
 *
 * 2004 (c) MontaVista, Software, Inc.  This file is licensed under the terms
 * of the GNU General Public License version 2.  This program is licensed
 * "as is" without any warranty of any kind, whether express or implied.
 */
#include <linux/config.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/ioport.h>
#include <linux/mm.h>
#include <linux/console.h>

#include <asm/cpu.h>
#include <asm/bootinfo.h>
#include <asm/irq.h>
#include <asm/keyboard.h>
#include <asm/mipsregs.h>
#include <asm/reboot.h>
#include <asm/time.h>
#include <asm/pgtable.h>
#include <linux/mc146818rtc.h>

#include <asm/intrinsity/fastmath.h>

#ifdef CONFIG_BLK_DEV_INITRD
extern unsigned long initrd_start, initrd_end;
extern void *__rd_start, *__rd_end;
#endif

extern struct rtc_ops no_rtc_ops;
extern char *__init prom_getcmdline(void);
extern void fm_restart(char *);
extern void fm_halt(void);
extern void fm_power_off(void);
extern struct resource ioport_resource;
extern struct resource iomem_resource;
extern void fm_time_init(void);
extern void fm_timer_setup(struct irqaction *);

void __init fm_setup(void)
{
	rtc_ops = &no_rtc_ops;
	_machine_restart = fm_restart;
	_machine_halt = fm_halt;
	_machine_power_off = fm_power_off;

	/* PCI IO/MEM resources. */
	set_io_port_base(FM_PCI_IO_BASE);
	ioport_resource.start = 0;
	ioport_resource.end = ioport_resource.start + FM_PCI_SIZE - 1;
	iomem_resource.start = FM_PCI_MEM_BASE;
	iomem_resource.end = iomem_resource.start + FM_PCI_SIZE - 1;
	/* 
	 * Establish mappings from kernel virtual to PCI I/O space.
	 * We use one permanent wired TLB entry to allocate 512Mb of
	 * kernel virtual space with a 1-to-1 virtual to physical mapping.
	 * This corresponds to the last 4 RapidIO regions in physical memory.
	 */
	add_wired_entry(0x03800017, 0x03C00017, 0xE0000000, PM_256M);

#ifdef CONFIG_BLK_DEV_INITRD
	ROOT_DEV = MKDEV(RAMDISK_MAJOR, 0);
	initrd_start = (unsigned long) &__rd_start;
	initrd_end = (unsigned long) &__rd_end;
#endif

	board_time_init = fm_time_init;
	board_timer_setup = fm_timer_setup;
}

void __init bus_error_init(void)
{				/* nothing */
}
