/*
 * arch/mips/intrinsity/common/reset.c
 *
 * FastMips/FastMATH reset routines.
 *
 * Author: MontaVista Software, Inc. <ppopov@mvista.com> or <source@mvista.com>
 *
 * 2001-2004 (c) MontaVista, Software, Inc.  This file is licensed under the 
 * terms of the GNU General Public License version 2.  This program is licensed
 * "as is" without any warranty of any kind, whether express or implied.
 */
#include <linux/sched.h>
#include <linux/mm.h>
#include <asm/io.h>
#include <asm/pgtable.h>
#include <asm/processor.h>
#include <asm/reboot.h>
#include <asm/system.h>
#include <asm/intrinsity/fastmath.h>

void fm_restart(char *command)
{
	FPGA(CONFIG) |= FM_FPGA_FORCERESET;
	while (1) ;
}

void fm_halt(void)
{
	printk(KERN_NOTICE "\n** You can safely turn off the power\n");
	while (1)
		__asm__(".set\tmips3\n\t" 
		        "wait\n\t" 
			".set\tmips0");
}

void fm_power_off(void)
{
	fm_halt();
}
