/*
 * arch/mips/intrinsity/common/puts.c
 *
 * Low level uart routines to directly access a 16550 uart.
 *
 * Author: MontaVista Software, Inc. <ppopov@mvista.com> or <source@mvista.com>
 *
 * 2001-2004 (c) MontaVista, Software, Inc.  This file is licensed under the 
 * terms of the GNU General Public License version 2.  This program is licensed
 * "as is" without any warranty of any kind, whether express or implied.
 */
#include <linux/types.h>

#define SERIAL_BASE   0xB4000000	/* fm, uart 0 */
#define UART_LSR	0x5
#define UART_TX		0x0
#define TX_EMPTY	0x20

#define TIMEOUT       0xfffffff

static const char digits[16] = "0123456789abcdef";
static volatile unsigned char *const com1 = (unsigned char *) SERIAL_BASE;

inline void putch(const unsigned char c)
{
	int i;

	asm("sync");
	for (i = 0; i < TIMEOUT; i++) {
		if (com1[UART_LSR] & TX_EMPTY)
			break;
	}
	com1[UART_TX] = c;
	asm("sync");
}

void puts(unsigned char *cp)
{
	while (*cp)
		putch(*cp++);
	putch('\r');
	putch('\n');
}

void fputs(unsigned char *cp)
{
	while (*cp)
		putch(*cp++);
}

void put64(uint64_t ul)
{
	int cnt;
	unsigned ch;

	cnt = 16;		/* 16 nibbles in a 64 bit long */
	putch('0');
	putch('x');
	do {
		cnt--;
		ch = (unsigned char) (ul >> cnt * 4) & 0x0F;
		putch(digits[ch]);
	} while (cnt > 0);
}

void put32(unsigned u)
{
	int cnt;
	unsigned ch;

	cnt = 8;		/* 8 nibbles in a 32 bit long */
	putch('0');
	putch('x');
	do {
		cnt--;
		ch = (unsigned char) (u >> cnt * 4) & 0x0F;
		putch(digits[ch]);
	} while (cnt > 0);
}
