/*
 * arch/mips/intrinsity/common/int-handler.S
 *
 * Interrupt dispatcher for Intrinsity boards.
 *
 * Author: MontaVista Software, Inc. <ppopov@mvista.com> or <source@mvista.com>
 *
 * 2001-2004 (c) MontaVista, Software, Inc.  This file is licensed under the 
 * terms of the GNU General Public License version 2.  This program is licensed
 * "as is" without any warranty of any kind, whether express or implied.
 */
#include <linux/config.h>
#include <asm/asm.h>
#include <asm/mipsregs.h>
#include <asm/addrspace.h>
#include <asm/regdef.h>
#include <asm/stackframe.h>
#include <asm/intrinsity/fastmath.h>

	.text
	.set	macro
	.set	noat
	.align	5

NESTED(fm_IRQ, PT_SIZE, sp)
	SAVE_ALL
	CLI				# Important: mark KERNEL mode !

	mfc0	t0,CP0_CAUSE		# get pending interrupts
	mfc0	t1,CP0_STATUS		# get enabled interrupts
	and	t0,t1			# isolate allowed ones

	andi	t0,0xff00		# isolate pending bits

	andi	a0, t0, CAUSEF_IP7
	beq	a0, zero, 1f
	move	a1, sp
	li	a0, FM_IRQ_TIMER
	jal	ll_timer_interrupt
	j	ret_from_irq
1:	
	andi	a0, t0, CAUSEF_IP5
	beq	a0, zero, 1f	       
	move	a0, sp  
	jal	fm_gpio_interrupt
	j	ret_from_irq
1:
	andi	a0, t0, CAUSEF_IP4
	beq	a0, zero, 1f	       
	move	a0,sp  
	jal	fm_dma_interrupt
	j	ret_from_irq
1:	
	move	a0, sp
	j	spurious_interrupt
END(fm_IRQ)
