/*
 * arch/mips/intrinsity/common/init.c
 *
 * Intrinsity FastMips/FastMATH setup
 *
 * Author: MontaVista Software, Inc. <source@mvista.com>
 *
 * 2004 (c) MontaVista, Software, Inc.  This file is licensed under the terms
 * of the GNU General Public License version 2.  This program is licensed
 * "as is" without any warranty of any kind, whether express or implied.
 */

#include <linux/init.h>
#include <linux/mm.h>
#include <linux/sched.h>
#include <linux/bootmem.h>
#include <asm/addrspace.h>
#include <asm/bootinfo.h>
#include <linux/config.h>
#include <linux/string.h>
#include <linux/kernel.h>
#include <linux/sched.h>

int prom_argc;
char **prom_argv, **prom_envp;
extern void __init prom_init_cmdline(void);
extern char *prom_getenv(char *envname);

static char *hack_argv[] = {
	"console=ttyS0,38400",
	"root=/dev/nfs",
	"ip=bootp",
	0
};
static int hack_argc = (sizeof (hack_argv) / sizeof (hack_argv[0])) - 1;

static char *hack_envp[] = {
	0
};

const char *get_system_type(void)
{
	return "Intrinsity Eval Board";
}

int __init prom_init(int argc, char **argv, char **envp, int *prom_vec)
{
	prom_argc = hack_argc;
	prom_argv = hack_argv;
	prom_envp = hack_envp;

	mips_machgroup = MACH_GROUP_INTRINSITY;
	mips_machtype = MACH_BUBBA;

	/* 1st DRAM bank */
	add_memory_region(0x00000000, 0x8000000, BOOT_MEM_RAM);	

	prom_init_cmdline();
	return 0;
}
