/*
 * BRIEF MODULE DESCRIPTION
 *	Au1xxx irq map table
 *
 * Copyright 2003 Embedded Edge, LLC
 *		dan@embeddededge.com
 *
 *  This program is free software; you can redistribute	 it and/or modify it
 *  under  the terms of	 the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the	License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED	  ``AS	IS'' AND   ANY	EXPRESS OR IMPLIED
 *  WARRANTIES,	  INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO	EVENT  SHALL   THE AUTHOR  BE	 LIABLE FOR ANY	  DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED	  TO, PROCUREMENT OF  SUBSTITUTE GOODS	OR SERVICES; LOSS OF
 *  USE, DATA,	OR PROFITS; OR	BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN	 CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <linux/errno.h>
#include <linux/init.h>
#include <linux/irq.h>
#include <linux/kernel_stat.h>
#include <linux/module.h>
#include <linux/signal.h>
#include <linux/sched.h>
#include <linux/types.h>
#include <linux/interrupt.h>
#include <linux/ioport.h>
#include <linux/timex.h>
#include <linux/slab.h>
#include <linux/random.h>
#include <linux/delay.h>

#include <asm/bitops.h>
#include <asm/bootinfo.h>
#include <asm/io.h>
#include <asm/mipsregs.h>
#include <asm/system.h>
#include <asm/au1000.h>

au1xxx_irq_map_t au1xxx_irq_map[] = {
#ifndef CONFIG_SOC_AU1550
	{ AU1000_UART0_INT, INTC_INT_HIGH_LEVEL, 0},
	{ AU1000_UART3_INT, INTC_INT_HIGH_LEVEL, 0},
	{ AU1000_DMA_INT_BASE, INTC_INT_HIGH_LEVEL, 0},
	{ AU1000_DMA_INT_BASE+1, INTC_INT_HIGH_LEVEL, 0},
	{ AU1000_DMA_INT_BASE+2, INTC_INT_HIGH_LEVEL, 0},
	{ AU1000_DMA_INT_BASE+3, INTC_INT_HIGH_LEVEL, 0},
	{ AU1000_DMA_INT_BASE+4, INTC_INT_HIGH_LEVEL, 0},
	{ AU1000_DMA_INT_BASE+5, INTC_INT_HIGH_LEVEL, 0},
	{ AU1000_DMA_INT_BASE+6, INTC_INT_HIGH_LEVEL, 0},
	{ AU1000_DMA_INT_BASE+7, INTC_INT_HIGH_LEVEL, 0},

	{ AU1000_IRDA_TX_INT, INTC_INT_HIGH_LEVEL, 0},
	{ AU1000_IRDA_RX_INT, INTC_INT_HIGH_LEVEL, 0},

	{ AU1000_MAC0_DMA_INT, INTC_INT_HIGH_LEVEL, 0},
#if defined(CONFIG_MIPS_DB1000) || defined(CONFIG_MIPS_DB1500) || defined(CONFIG_MIPS_MIRAGE)
	{ AU1000_MAC1_DMA_INT, INTC_INT_HIGH_LEVEL, 0},
#endif
#ifndef CONFIG_MIPS_MIRAGE
	{ AU1500_GPIO_204, INTC_INT_HIGH_LEVEL, 0},
#endif

	{ AU1000_USB_HOST_INT, INTC_INT_LOW_LEVEL, 0 },

#ifdef CONFIG_SOC_AU1500
	{ AU1000_PCI_INTA, INTC_INT_LOW_LEVEL, 0 },
	{ AU1000_PCI_INTB, INTC_INT_LOW_LEVEL, 0 },
	{ AU1000_PCI_INTC, INTC_INT_LOW_LEVEL, 0 },
	{ AU1000_PCI_INTD, INTC_INT_LOW_LEVEL, 0 },
#endif

#ifdef CONFIG_MIPS_DB1500
	{ AU1500_GPIO_201, INTC_INT_LOW_LEVEL, 0 },
	{ AU1500_GPIO_202, INTC_INT_LOW_LEVEL, 0 },
	{ AU1500_GPIO_203, INTC_INT_LOW_LEVEL, 0 },
	{ AU1500_GPIO_205, INTC_INT_LOW_LEVEL, 0 },
	{ AU1500_GPIO_207, INTC_INT_LOW_LEVEL, 0 },
#endif

#ifndef CONFIG_MIPS_MIRAGE
	{ AU1000_GPIO_0, INTC_INT_LOW_LEVEL, 0 }, // PCMCIA Card 0 Fully_Interted#
	{ AU1000_GPIO_1, INTC_INT_LOW_LEVEL, 0 }, // PCMCIA Card 0 STSCHG#
	{ AU1000_GPIO_2, INTC_INT_LOW_LEVEL, 0 }, // PCMCIA Card 0 IRQ#

	{ AU1000_GPIO_3, INTC_INT_LOW_LEVEL, 0 }, // PCMCIA Card 1 Fully_Interted#
	{ AU1000_GPIO_4, INTC_INT_LOW_LEVEL, 0 }, // PCMCIA Card 1 STSCHG#
	{ AU1000_GPIO_5, INTC_INT_LOW_LEVEL, 0 }, // PCMCIA Card 1 IRQ#
#endif
	{ AU1000_ACSYNC_INT, INTC_INT_RISE_EDGE, 0 },
	{ AU1000_AC97C_INT, INTC_INT_RISE_EDGE, 0 },
	{ AU1000_TOY_INT, INTC_INT_RISE_EDGE, 0 },
	{ AU1000_TOY_MATCH0_INT, INTC_INT_RISE_EDGE, 0 },
	{ AU1000_TOY_MATCH1_INT, INTC_INT_RISE_EDGE, 0 },
	{ AU1000_USB_DEV_SUS_INT, INTC_INT_RISE_EDGE, 0 },
	{ AU1000_USB_DEV_REQ_INT, INTC_INT_RISE_EDGE, 0 },
	{ AU1000_RTC_INT, INTC_INT_RISE_EDGE, 0 },
	{ AU1000_RTC_MATCH0_INT, INTC_INT_RISE_EDGE, 0 },
	{ AU1000_RTC_MATCH1_INT, INTC_INT_RISE_EDGE, 0 },
	{ AU1000_RTC_MATCH2_INT, INTC_INT_RISE_EDGE, 0 },

	/* Careful if you change match 2 request!
	 * The interrupt handler is called directly
	 * from the low level dispatch code.
	 */
	{ AU1000_TOY_MATCH2_INT, INTC_INT_RISE_EDGE, 1 },
#else /* SOC_AU1550 */
	{ AU1550_UART0_INT,          INTC_INT_HIGH_LEVEL, 0},
	{ AU1550_PCI_INTA,           INTC_INT_LOW_LEVEL, 0 },
	{ AU1550_PCI_INTB,           INTC_INT_LOW_LEVEL, 0 },
	{ AU1550_DDMA_INT,           INTC_INT_HIGH_LEVEL, 0},
	{ AU1550_CRYPTO_INT,         INTC_INT_HIGH_LEVEL, 0},
	{ AU1550_PCI_INTC,           INTC_INT_LOW_LEVEL, 0 },
	{ AU1550_PCI_INTD,           INTC_INT_LOW_LEVEL, 0 },
	{ AU1550_PCI_RST_INT,        INTC_INT_LOW_LEVEL, 0 },
	{ AU1550_UART1_INT,          INTC_INT_HIGH_LEVEL, 0},
	{ AU1550_UART3_INT,          INTC_INT_HIGH_LEVEL, 0},
	{ AU1550_PSC0_INT,           INTC_INT_HIGH_LEVEL, 0},
	{ AU1550_PSC1_INT,           INTC_INT_HIGH_LEVEL, 0},
	{ AU1550_PSC2_INT,           INTC_INT_HIGH_LEVEL, 0},
	{ AU1550_PSC3_INT,           INTC_INT_HIGH_LEVEL, 0},
	{ AU1550_TOY_INT,            INTC_INT_RISE_EDGE, 0 },
	{ AU1550_TOY_MATCH0_INT,     INTC_INT_RISE_EDGE, 0 },
	{ AU1550_TOY_MATCH1_INT,     INTC_INT_RISE_EDGE, 0 },
	{ AU1550_TOY_MATCH2_INT,     INTC_INT_RISE_EDGE, 1 },
	{ AU1550_RTC_INT,            INTC_INT_RISE_EDGE, 0 },
	{ AU1550_RTC_MATCH0_INT,     INTC_INT_RISE_EDGE, 0 },
	{ AU1550_RTC_MATCH1_INT,     INTC_INT_RISE_EDGE, 0 },
	{ AU1550_RTC_MATCH2_INT,     INTC_INT_RISE_EDGE, 0 },
	{ AU1550_PCI_ERROR_INT,      INTC_INT_HIGH_LEVEL, 0},
	{ AU1550_NAND_INT,           INTC_INT_RISE_EDGE, 0 },
	{ AU1550_USB_DEV_REQ_INT,    INTC_INT_HIGH_LEVEL, 0},
	{ AU1550_USB_DEV_SUS_INT,    INTC_INT_RISE_EDGE, 0 },
	{ AU1550_USB_HOST_INT,       INTC_INT_LOW_LEVEL, 0 },
	{ AU1550_MAC0_DMA_INT,       INTC_INT_HIGH_LEVEL, 0},
	{ AU1550_MAC1_DMA_INT,       INTC_INT_HIGH_LEVEL, 0},

	{ AU1000_GPIO_0, INTC_INT_LOW_LEVEL, 0 },
	{ AU1000_GPIO_1, INTC_INT_LOW_LEVEL, 0 },
	{ AU1000_GPIO_2, INTC_INT_LOW_LEVEL, 0 },
	{ AU1000_GPIO_3, INTC_INT_LOW_LEVEL, 0 },
	{ AU1000_GPIO_4, INTC_INT_LOW_LEVEL, 0 },
	{ AU1000_GPIO_5, INTC_INT_LOW_LEVEL, 0 },
	{ AU1000_GPIO_6, INTC_INT_LOW_LEVEL, 0 },
	{ AU1000_GPIO_7, INTC_INT_LOW_LEVEL, 0 },
	{ AU1000_GPIO_8, INTC_INT_LOW_LEVEL, 0 },
	{ AU1000_GPIO_9, INTC_INT_LOW_LEVEL, 0 },
	{ AU1000_GPIO_10, INTC_INT_LOW_LEVEL, 0 },
	{ AU1000_GPIO_11, INTC_INT_LOW_LEVEL, 0 },
	{ AU1000_GPIO_12, INTC_INT_LOW_LEVEL, 0 },
	{ AU1000_GPIO_13, INTC_INT_LOW_LEVEL, 0 },
	{ AU1000_GPIO_14, INTC_INT_LOW_LEVEL, 0 },
	{ AU1000_GPIO_15, INTC_INT_LOW_LEVEL, 0 },
	
	{ AU1550_GPIO_200,           INTC_INT_LOW_LEVEL, 0 },
	{ AU1550_GPIO_201_205,       INTC_INT_LOW_LEVEL, 0 },
	{ AU1550_GPIO_16,            INTC_INT_LOW_LEVEL, 0 },
	{ AU1550_GPIO_17,            INTC_INT_LOW_LEVEL, 0 },
	{ AU1550_GPIO_20,            INTC_INT_LOW_LEVEL, 0 },
	{ AU1550_GPIO_21,            INTC_INT_LOW_LEVEL, 0 },
	{ AU1550_GPIO_22,            INTC_INT_LOW_LEVEL, 0 },
	{ AU1550_GPIO_23,            INTC_INT_LOW_LEVEL, 0 },
	{ AU1550_GPIO_24,            INTC_INT_LOW_LEVEL, 0 },
	{ AU1550_GPIO_25,            INTC_INT_LOW_LEVEL, 0 },
	{ AU1550_GPIO_26,            INTC_INT_LOW_LEVEL, 0 },
	{ AU1550_GPIO_27,            INTC_INT_LOW_LEVEL, 0 },
	{ AU1550_GPIO_28,            INTC_INT_LOW_LEVEL, 0 },
	{ AU1550_GPIO_206,           INTC_INT_LOW_LEVEL, 0 },
	{ AU1550_GPIO_207,           INTC_INT_LOW_LEVEL, 0 },
	{ AU1550_GPIO_208_215,       INTC_INT_LOW_LEVEL, 0 },
#endif /* SOC_AU1550 */
};

int au1xxx_nr_irqs = sizeof(au1xxx_irq_map)/sizeof(au1xxx_irq_map_t);

#ifdef CONFIG_PCI
/*
 * The following macro is used to lookup irqs in a standard table
 * format for those systems that do not already have PCI
 * interrupts properly routed.
 */
#define PCI_IRQ_TABLE_LOOKUP                                            \
({ long _ctl_ = -1;                                                     \
   if (idsel >= min_idsel && idsel <= max_idsel && pin <= irqs_per_slot) \
	 _ctl_ = pci_irq_table[idsel - min_idsel][pin-1]; \
   _ctl_; })

#ifdef CONFIG_SOC_AU1500
#define INTA AU1000_PCI_INTA
#define INTB AU1000_PCI_INTB
#define INTC AU1000_PCI_INTC
#define INTD AU1000_PCI_INTD
#endif

#ifdef CONFIG_SOC_AU1550
#define INTA AU1550_PCI_INTA
#define INTB AU1550_PCI_INTB
#define INTC AU1550_PCI_INTC
#define INTD AU1550_PCI_INTD
#endif

#define INTX 0xFF /* not valid */

int __init
au1xxx_pci_irqmap(struct pci_dev *dev, unsigned char idsel, unsigned char pin)
{
	/*
	 *	PCI IDSEL/INTPIN->INTLINE
	 *	A       B       C       D
	 */
#ifdef CONFIG_MIPS_DB1500
	static char pci_irq_table[][4] =
	{
		{INTA, INTX, INTX, INTX},   /* IDSEL 12 - HPT371   */
		{INTA, INTB, INTC, INTD},   /* IDSEL 13 - PCI slot */
	};
	const long min_idsel = 12, max_idsel = 13, irqs_per_slot = 4;
#endif

#ifdef CONFIG_MIPS_BOSPORUS
	static char pci_irq_table[][4] =
	{
		{INTA, INTB, INTX, INTX},   /* IDSEL 11 - miniPCI  */
		{INTA, INTX, INTX, INTX},   /* IDSEL 12 - SN1741   */
		{INTA, INTB, INTC, INTD},   /* IDSEL 13 - PCI slot */
	};
	const long min_idsel = 11, max_idsel = 13, irqs_per_slot = 4;
#endif

#ifdef CONFIG_MIPS_MIRAGE
	static char pci_irq_table[][4] =
	{
		{INTD, INTX, INTX, INTX},   /* IDSEL 11 - SMI VGX */
		{INTX, INTX, INTC, INTX},   /* IDSEL 12 - PNX1300 */
		{INTA, INTB, INTX, INTX},   /* IDSEL 13 - miniPCI */
	};
	const long min_idsel = 11, max_idsel = 13, irqs_per_slot = 4;
#endif

#ifdef CONFIG_MIPS_DB1550
	static char pci_irq_table[][4] =
	{
		{INTC, INTX, INTX, INTX},   /* IDSEL 11 - on-board HPT371    */
		{INTB, INTC, INTD, INTA},   /* IDSEL 12 - PCI slot 2 (left)  */
		{INTA, INTB, INTC, INTD},   /* IDSEL 13 - PCI slot 1 (right) */
	};
	const long min_idsel = 11, max_idsel = 13, irqs_per_slot = 4;
#endif
#if defined(CONFIG_SOC_AU1550) || defined(CONFIG_SOC_AU1500)
	return PCI_IRQ_TABLE_LOOKUP;
#else
	return 0;
#endif
};
#endif

