/*
 *
 * Copyright 2002 MontaVista Software Inc.
 * Author: MontaVista Software, Inc.
 *		ppopov@mvista.com or source@mvista.com
 *
 * Robert Lembree, lembree@metrolink.com
 * Copyright (C) 2001, Metro Link, Inc., All rights reserved
 *
 * Carsten Langgaard, carstenl@mips.com
 * Copyright (C) 2000 MIPS Technologies, Inc.  All rights reserved.
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 */

#include <linux/config.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/ioport.h>
#include <linux/console.h>
#include <linux/pci.h>
#include <linux/module.h>
#if defined(CONFIG_BLK_DEV_IDE) || defined(CONFIG_BLK_DEV_IDE_MODULE)
#include <linux/ide.h>
#endif
#include <linux/mc146818rtc.h>

#include <asm/cpu.h>
#include <asm/bootinfo.h>
#include <asm/irq.h>
#include <asm/ati/prom.h>
#include <asm/ati/xilleon.h>
#include <asm/ati/xilleonint.h>
#include <asm/ati/pci.h>
#ifdef CONFIG_BLK_DEV_FD
#include <asm/floppy.h>
#endif
#include <asm/dma.h>

#if defined(CONFIG_SERIAL_CONSOLE) || defined(CONFIG_PROM_CONSOLE)
extern void console_setup(char *);
char serial_console[20];
#endif

#ifdef CONFIG_KGDB
extern void set_debug_traps(void);
extern void rs_kgdb_hook(int);
extern void breakpoint(void);
#endif

#if defined(CONFIG_BLK_DEV_IDE) || defined(CONFIG_BLK_DEV_IDE_MODULE)
extern struct ide_ops std_ide_ops;
#endif

#ifdef CONFIG_BLK_DEV_FD
extern struct fd_ops std_fd_ops;
#endif

#ifdef CONFIG_RTC
extern struct rtc_ops xilleon_rtc_ops;
#endif

#ifdef CONFIG_BLK_DEV_INITRD
extern unsigned long initrd_start, initrd_end;
extern void * __rd_start, * __rd_end;
#endif

void (*__wbflush) (void);
extern void xilleon_reboot_setup(void);
extern int xilleon_read_config_byte(struct pci_dev *, int, u8 *);
extern int xilleon_write_config_byte(struct pci_dev *, int, u8);

void xilleon_wbflush(void)
{
	__asm__ volatile ("sync");
}

void __init xilleon_serial_console_setup(void)
{
	char *argptr = prom_getcmdline();

	/* We need to do this early on to get prom_printf()
	 * to use the right port.
	 */
#ifdef CONFIG_SERIAL_CONSOLE
	int line;
	if ((argptr = strstr(argptr, "console=ttyS")) == NULL) {
		
#ifdef CONFIG_IKOS
		char s[] = "6082,n,8,1,hw";
#else
		char s[] = "115200,n,8,1";
#endif

		argptr = prom_getcmdline();
		strcat(argptr, " console=ttyS0,");
		strcat(argptr, s);
		setup_prom_printf(0);
	}
	else {
		argptr += strlen("console=ttyS");
		if (*argptr != '0' && *argptr != '1')
			printk("Uknown serial line /dev/ttyS%c, "
			       "falling back to /dev/ttyS0\n", *argptr);
		line = *argptr == '1' ? 1 : 0;
		setup_prom_printf(1);
	}
#else
	/* Default to ttyS0 */
	setup_prom_printf(0);
#endif
}

#define STANDARD_IO_RESOURCES (sizeof(standard_io_resources)/sizeof(struct resource))

void __init xilleon_setup(void)
{
	u32 val = 0;
	char *argptr;
	u8 data;
	struct pci_bus dummy_bus;
	struct pci_dev dummy_dev;
#ifdef CONFIG_KGDB
	int line;
#endif

        __wbflush = xilleon_wbflush;

#ifdef CONFIG_KGDB
	/* Default kgdb port is ttyS1 */
	argptr = prom_getcmdline();
	line = 1;
	if ((argptr = strstr(argptr, "kgdb=ttyS")) != NULL) {
		argptr += strlen("kgdb=ttyS");
		if (*argptr != '0' && *argptr != '1')
			printk("KGDB: Uknown serial line /dev/ttyS%c, "
			       "falling back to /dev/ttyS1\n", *argptr);
		line = *argptr == '0' ? 0 : 1;
	}
	printk("KGDB: Using serial line /dev/ttyS%d for session\n",
	       line ? 1 : 0);

	rs_kgdb_hook(line);
#endif
		
#ifdef CONFIG_RTC
	rtc_ops = &xilleon_rtc_ops;
#endif

#if defined(CONFIG_BLK_DEV_IDE) || defined(CONFIG_BLK_DEV_IDE_MODULE)
        ide_ops = &std_ide_ops;
#endif
#ifdef CONFIG_BLK_DEV_FD
        fd_ops = &std_fd_ops;
#endif

#ifdef CONFIG_FB
	conswitchp = &dummy_con;
#endif

#ifdef CONFIG_BLK_DEV_INITRD
	ROOT_DEV = MKDEV(RAMDISK_MAJOR, 0);
	initrd_start = (unsigned long)&__rd_start;
	initrd_end = (unsigned long)&__rd_end;
#endif
	/* pmon does the following init, but if we're using the
	 * tiny pmon for boot from flash purposes, none of this will
	 * be done.
	 */

	/* start boot init section */
	// set PCI pad strengths
	SETREG_REGMM32(PAD_PCI, 0x00000103);

	// turn on southbridge config
	SETFLD_REGMM32(PCIC_DEBUG_CNTL, EN_IDE_CONFIG, 1);
	SETFLD_REGMM32(PCIC_DEBUG_CNTL, EN_USB_CONFIG, 1);
	SETFLD_REGMM32(PCIC_DEBUG_CNTL, EN_LPC_CONFIG, 1);
	SETFLD_REGMM32(PCIC_DEBUG_CNTL, EN_DAIO_CONFIG, 1);

	// enable memory access in pci space for dma
	SETFLD_REGMM32(PCIC_COMMAND_STATUS, MEM_ACCESS_EN, 1);

	// enable system error reporting
	SETFLD_REGMM32(PCIC_BUS_CNTL, SERR_EN, 1);

	// enable read bursts
	SETFLD_REGMM32(PCIC_BUSSLAVE_CNTL, BUS_READ_BURST, 1);

	dummy_dev.bus = &dummy_bus;
	dummy_dev.bus->number = 0;
	dummy_dev.devfn = (20 << 3) | 1;
	xilleon_read_config_byte(&dummy_dev, PCI_CLASS_PROG, &data);
	data |= 1;
	xilleon_write_config_byte(&dummy_dev, PCI_CLASS_PROG, data);
	/* end boot init section */

	/* PCI Bus Setup */
	/* enable SB devices */
	/* added enable automatic invalidation of the PCI read 
	 * prefetch cache, set the bit 5 */
 
	SETREG_REGMM32(PCIC_DEBUG_CNTL, 0x0000000F | 0x00000020);
	udelay(1000);
	
	/* should already be given to us by PMON */
	/* set pci1 aperture (memory) */
	SETREG_REGMM32(APER_CP_PCIC1_ADDR,
		       XILLEON_PCI_MEMORY_APER_BASEOUT | 
		       XILLEON_PCI_MEMORY_APER_BASE>>16);
	
	/* set pci2 aperture (shared i/o & config) */

	SETREG_REGMM32(APER_CP_PCIC2_ADDR, XILLEON_PCI_IO_APER_BASE>>16);

        /* change pci2 aperture to i/o */

	val = GETREG_REGMM32(APER_CP_PCIC2_CNTL);
	
	MODIFYFLD(val, APER_CP_PCIC2_CNTL,
		  PCI_ATYPE, PCI_ATYPE_IO);
	
	SETREG_REGMM32(APER_CP_PCIC2_CNTL, val);

	xilleon_reboot_setup();

	/* kernel debug/test message */
	/*
	printk("KSEG1: 0x%x APER_PCU_BASE: 0x%x  APER_PCU_IPA_BASE: 0x%x\n",
	       KSEG1, APER_PCU_BASE, APER_PCU_IPA_BASE);
	*/

	/* set PAD_USB1/PAD_USB2 to best default values for full speed */
#if 0
	printk(KERN_INFO 
	       "Xilleon REG value before setting: PAD_USB1: 0x%x, PAD_USB2: 0x%x\n",
	       GETREG_REGMM32(PAD_USB1),
	       GETREG_REGMM32(PAD_USB2));
#endif
	SETREG_REGMM32(PAD_USB1, 0x00000f43);
	SETREG_REGMM32(PAD_USB2, 0x00000f43);
#if 0
	printk(KERN_INFO 
	       "Xilleon REG value after setting: PAD_USB1: 0x%x, PAD_USB2: 0x%x\n",
	       GETREG_REGMM32(PAD_USB1),
	       GETREG_REGMM32(PAD_USB2));
#endif
#if 0
	printk("Start PLL debug ...\n");
	for (val = 0; val < 0x40; val++) {
		*((unsigned long *)(0xb8000008)) = val;
		printk("index %x:: %x\n", val, *((unsigned long *)0xb800000c));
	}
#endif
}
