/*
 * Robert Lembree, lembree@metrolink.com
 * Copyright (C) 2001, Metro Link, Inc., All rights reserved.
 *
 * based on work by
 *
 * Carsten Langgaard, carstenl@mips.com
 * Copyright (C) 1999, 2000 MIPS Technologies, Inc.  All rights reserved.
 *
 * ########################################################################
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ########################################################################
 *
 * Interrupt exception dispatch code for ATI Xilleon
 *
 */
#include <linux/config.h>

#include <asm/asm.h>
#include <asm/mipsregs.h>
#include <asm/regdef.h>
#include <asm/stackframe.h>

#define DEBUG
    
/*
 * IRQs on the ATI Xilleon are arranged in groups thusly:
 *
 *	MIPS IRQ	Source
 *      --------        ------
 *             0	Software (ignored)
 *             1        Software (ignored)
 *             2        Hardware (HW0, ignored)	
 *             3        Peripheral Control Unit (PCU) (HW1)
 *             4        Firmware (HW2)
 *             5        PCI (HW3)
 *             6        Southbridge (HW4)
 *             7        R4k timer (INT 5)
 *
 * Each MIPS IRQ has multiple causes.  For simplicity's
 * sake, we just call a different function for each
 * MIPS interrupt, and let the upper layers of code
 * translate to the kernel's interrupt numbers.
 *
 * We handle the IRQ according to _our_ priority which is:
 *
 * Highest ----     Peripheral Control Unit (PCU)
 *                  Firmware
 *                  PCI
 *                  Southbridge
 * Lowest  ----     R4k Timer
 */


	.text
	.set	noat
	.align	5
	NESTED(xilleonIRQ, PT_SIZE, sp)
	SAVE_ALL

	CLI
	.set	at

    mfc0	s0, CP0_CAUSE		# get irq mask
    nop
    nop
    andi	a0, s0, CAUSEF_IP3|CAUSEF_IP4|CAUSEF_IP5|CAUSEF_IP6|CAUSEF_IP7
    beq     a0, zero, 1f

    move	a0, sp
    jal	xilleon_irqdispatch
    nop
   
    j	ret_from_irq
    nop

1:
	/*
	 * Here by mistake?  This is possible, what can happen is that by the
	 * time we take the exception the IRQ pin goes low, so just leave if
	 * this is the case.
	 */

#if 0
	move	a1,s0
	PRINT("Got interrupt: c0_cause = %08x\n")
	mfc0	a1, CP0_EPC
	PRINT("c0_epc = %08x\n")
#endif

    j	spurious_interrupt
    nop

    END(xilleonIRQ)
