/*
 * Robert Lembree, lembree@metrolink.com
 * Copyright (C) 2001 Metro Link, Inc.  All rights reserved.
 *
 * ########################################################################
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ########################################################################
 */

#include <linux/config.h>
#include <asm/reboot.h>
#include <asm/ati/xilleon.h>

extern void pflashClearStateMachine(void);

static void xilleon_restart(char *command)
{
	int cntl_val = GETREG_REGMM32(MIPS_CNTL);
    int r;
    uint32_t bootrom_straps;
   
	printk("Warm reset\n");

    bootrom_straps = GETREG_REGMM32(STRAPS_VALUE) & STRAPS__BOOTROM_SEL__MASK;

#if defined (CONFIG_STW5X226)
  switch(bootrom_straps)
    {
    case STRAPS__BOOTROM_SEL__NOR_8:
    case STRAPS__BOOTROM_SEL__NOR_16:
      pcuSetMode(PCU_MODE_FLEXBUS);
      printk("Boot strap: NOR...\n");
      break;
    case STRAPS__BOOTROM_SEL__NAND_32Mb:
    case STRAPS__BOOTROM_SEL__NAND_64Mb:
    case STRAPS__BOOTROM_SEL__NAND_128Mb:
      pcuSetMode(PCU_MODE_PFLASH_32MBIT);
      printk("Boot strap: NAND...\n");
      break;
    case STRAPS__BOOTROM_SEL__ST_M25P80:
      pcuSetMode(PCU_MODE_SFLASH_SEPST80);
      printk("Boot strap: SFLASH M25P80...\n");
      break;
    }

  /* set PCU aperture */
  SETREG_REGMM32(APER_CP_PCU_ADDR, 0x1c000000>>16);
  SETREG_REGMM32(APER_CP_PCU_CNTL, 0xb); /* 64MB */

  /* set register aperture */
  SETREG_REGMM32(MIPS_REGISTER_APERTURE_BASE, 0x18000000);
#endif

#if defined (CONFIG_STW4X225)
  switch(bootrom_straps)
    {
    case STRAPS__BOOTROM_SEL__NAND_32Mb:
    case STRAPS__BOOTROM_SEL__NAND_64Mb:
    case STRAPS__BOOTROM_SEL__NAND_128Mb:
      pcuSetMode(PCU_MODE_PFLASH_32MBIT);
      printk("Boot strap: NAND...\n");
      break;

    case STRAPS__BOOTROM_SEL__ST_M25P10:
      pcuSetMode(PCU_MODE_SFLASH_SEPST10);
      printk("Boot strap: SFLASH M25P10...\n");
      break;
    }
#endif
   
	MODIFYFLD(cntl_val, MIPS_CNTL, WARM_RESET, 1);

	SETREG_REGMM32(MIPS_CNTL, cntl_val);
	set_c0_status(ST0_BEV | ST0_ERL);
	set_c0_config(CONF_CM_UNCACHED);
	flush_cache_all();
	write_c0_wired(0);
	__asm__ __volatile__("jr\t%0"::"r"(0xbfc00000));
	while(1);
}

static void xilleon_halt(void)
{
	int cntl_val = GETREG_REGMM32(MIPS_CNTL);

	printk("Cold reset\n");

	MODIFYFLD(cntl_val, MIPS_CNTL, COLD_RESET, 1);

	SETREG_REGMM32(MIPS_CNTL, cntl_val);
	while(1);
}


void xilleon_reboot_setup(void)
{
	_machine_restart = xilleon_restart;
	_machine_halt = xilleon_halt;
	_machine_power_off = xilleon_halt;
}
