/*
 * BRIEF MODULE DESCRIPTION
 *	Board specific pci fixups.
 *
 * Author: Pete Popov <ppopov@mvista.com, or source@mvista.com>
 *
 *   PCI functions code based on:
 *   Robert Lembree, lembree@metrolink.com
 *   Copyright (C) 2001, Metro Link, Inc., All rights reserved
 *
 * 2002 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#include <linux/config.h>

#ifdef CONFIG_PCI

#include <linux/types.h>
#include <linux/pci.h>
#include <linux/kernel.h>
#include <linux/init.h>

#include <asm/ati/xilleon.h>
#include <asm/ati/pci.h>
#include <asm/ati/xilleonint.h>

#undef	DEBUG
#ifdef 	DEBUG
#define	DBG(x...)	printk(x)
#else
#define	DBG(x...)	
#endif

void __init pcibios_fixup_resources(struct pci_dev *dev)
{
	/* will need to fixup IO resources */
}

void __init pcibios_fixup(void)
{
}

void __init pcibios_fixup_irqs(void)
{
        struct pci_dev *dev;
        int slot_num = 0;
	int pci_func = 0; 
    uint32_t r = 0;
	u8 interrupt = 0;

	pci_for_each_dev(dev) {
		slot_num = PCI_SLOT(dev->devfn);
		pci_func = PCI_SLOT(dev->devfn);
		pci_read_config_byte(dev, PCI_INTERRUPT_LINE, &interrupt);

		if (dev->vendor == PCI_VENDOR_ID_ATI) {
			switch (dev->device) {
			case PCI_DEVICE_ID_ATI_X220_IDE:
				dev->irq = XILLEON_IDE_INT;
				pci_write_config_byte(dev, PCI_INTERRUPT_LINE, 
						      XILLEON_IDE_INT);
				break;
                        /* x225 IDE changed */
			case PCI_DEVICE_ID_ATI_X225_IDE:
			case PCI_DEVICE_ID_ATI_X226_IDE:
			  r = GETREG_REGMM32(GPIO_SEL);
			  r |= (1<<GPIOSEL__IDE);
			  SETREG_REGMM32(GPIO_SEL, r);
			  #ifdef CONFIG_XILLEON_IDE_SEC
				dev->irq = X225_IDE_INT_SEC;
				pci_write_config_byte(dev, PCI_INTERRUPT_LINE, 
						      X225_IDE_INT_SEC);
			  #else
				dev->irq = X225_IDE_INT;
				pci_write_config_byte(dev, PCI_INTERRUPT_LINE, 
						      X225_IDE_INT);
              #endif

				break;
			case PCI_DEVICE_ID_ATI_X220_USB:
			case PCI_DEVICE_ID_ATI_X225_USB:
			case PCI_DEVICE_ID_ATI_X226_USB:
				dev->irq = XILLEON_USB_INT;
				pci_write_config_byte(dev, PCI_INTERRUPT_LINE,
						      XILLEON_USB_INT);
				break;
			case PCI_DEVICE_ID_ATI_X220_LPC:
                /* LPC not supported after x220 */
				dev->irq = XILLEON_LPC1_INT;
				pci_write_config_byte(dev, PCI_INTERRUPT_LINE, 
						      XILLEON_LPC1_INT);
				break;
			case PCI_DEVICE_ID_ATI_X220_DAIO:
			case PCI_DEVICE_ID_ATI_X225_DAIO:
			case PCI_DEVICE_ID_ATI_X226_DAIO:
				dev->irq = XILLEON_DAIO1_INT;
				pci_write_config_byte(dev, PCI_INTERRUPT_LINE,
						      XILLEON_DAIO1_INT);
				break;
			default:
				break;
			}
		}
		else {
		/*
		 * If not an ATI vendor code, assume this device is on the 
		 * external PCI bus and allocate an IRQ from the appropriate 
		 * pool.  Note that we don't care what pmon has done with the
		 * pci bus init -- we redo everything again.  
		 * Also note that non-ATI devices can only live on 
		 * the external bus, and ATI devices can only be builtin.
		 */ 
			/* first external pci slot is 9 */
			dev->irq = EXTPCI_IRQBASE + slot_num - 9; 
			printk("irq fixup slot %d vendor %x irq %d\n", 
					slot_num, dev->vendor, dev->irq);
			pci_write_config_byte(dev, PCI_INTERRUPT_LINE, 
					dev->irq);

		}
	}
}

unsigned int pcibios_assign_all_busses(void)
{
	return 0;
}
#endif
