Summary: kernel module utilities
Name: modutils
Version: 2.4.21
Release: 3.0.0.%{_hhl_build_id}
Source: modutils-%{version}.tar.bz2
Source1: modutils.tmpl
Patch: modutils-2.4.10-sh.patch
Patch2: modutils-2.4.13-arm_sa_be.patch
Patch3: modutils_2.4.13-3.diff.gz
Patch4: modutils-init.diff
Patch5: modutils-2.4.16-ignore.patch
Patch6: mvl-modutils-xtensa.patch
Patch7: modutils-dwarf2-section.diff
Source2: modutils-default.config
License: GPL
Group: Utilities/System
BuildRoot: %{_tmppath}/%{name}-target-%{_hhl_target_arch}-root
Prefix: %{_hhl_cross_target_dir}
%define _defaultdocdir  %{_hhl_cross_target_dir}%{_hhl_target_doc_dir}
Requires: hardhatutils
Obsoletes : hhl-target-modutils
Obsoletes : hhl-%{_hhl_target_arch}-modutils

%description
The Linux kernel allows new kernel pieces to be loaded and old ones to
be unloaded while the kernel continues to run. These loadable pieces
are called modules, and can include device drivers and filesystems among
other things. This package includes program to load and unload programs
both automatically and manually.


%prep
%target_check
%setup -q -n modutils-%{version}
%patch -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p0


%build
%target_setup
BUILDCC=gcc \
 CFLAGS="$RPM_OPT_FLAGS" \
 INSTALL=`pwd`/install-sh \
 %target_configure --enable-insmod-static

%make BUILDCC=gcc dep all


%install
%target_setup
rm -rf %{buildroot}

mkdir -p %{buildroot}%{_hhl_cross_target_dir}/sbin
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man{1,2,5,8}

export STRIPPROG="true "

%target_makeinstall \
	sbindir=%{buildroot}%{_hhl_cross_target_dir}/sbin \
	INSTALL=`pwd`/../install-sh

# kerneld is not compiled by default, it is obsolete for kernel >= 2.1.91.
# (cd kerneld;
# make install-scripts prefix=$RPM_BUILD_ROOT/usr exec_prefix=$RPM_BUILD_ROOT
# )
# security hole, works poorly anyway
rm -f %{buildroot}%{_hhl_cross_target_dir}/sbin/request-route

mkdir -p %{buildroot}%{_hhl_cross_target_dir}/etc
install -m 644 ../depmod/Example.modules.conf %{buildroot}%{_hhl_cross_target_dir}/etc/modules.conf.example
install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/cron.daily
install -m 755 ../debian/cron.daily %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/cron.daily/modutils
install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/init.d
install -m 755 ../debian/rc.modutils %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/init.d/modutils
install -m 644 ../debian/modules %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir} 
install -m 644 ../debian/modules.5 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man5/
install -m 644 %{SOURCE2} %{buildroot}%{_hhl_cross_target_dir}/etc/modules.conf
gzip -v9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man*/*
cd ..
cp COPYING LICENSE

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/modutils

%clean
rm -rf %{buildroot}

%post -n modutils
%target_script_prefix_setup
# Register the service
(%{_hhl_target_toolprefix}initdconfig --add modutils) &> /dev/null \
        || echo "Unable to enable initd service: modutils"


%files -n modutils
%defattr(-,root,root)
%attr(644,root,root) %config %{_hhl_cross_target_dir}/etc/modules.conf.example
%attr(644,root,root) %config %{_hhl_cross_target_dir}/etc/modules.conf
%attr(755,root,root)%{_hhl_cross_target_dir}/sbin/depmod
%attr(755,root,root)%{_hhl_cross_target_dir}/sbin/genksyms
%attr(755,root,root)%{_hhl_cross_target_dir}/sbin/insmod
%attr(755,root,root)%{_hhl_cross_target_dir}/sbin/insmod.static
#%attr(755,root,root)%{_hhl_cross_target_dir}/sbin/kerneld
%attr(755,root,root)%{_hhl_cross_target_dir}/sbin/ksyms
%attr(755,root,root)%{_hhl_cross_target_dir}/sbin/lsmod
%attr(755,root,root)%{_hhl_cross_target_dir}/sbin/modinfo
%attr(755,root,root)%{_hhl_cross_target_dir}/sbin/modprobe
%attr(755,root,root)%{_hhl_cross_target_dir}/sbin/rmmod
%attr(755,root,root)%{_hhl_cross_target_dir}/sbin/kallsyms
%attr(755,root,root)%{_hhl_cross_target_dir}/sbin/insmod_ksymoops_clean
%attr(755,root,root)%{_hhl_cross_target_dir}/sbin/kernelversion
%attr(644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/kernelversion.1*
%attr(644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man2/create_module.2*
%attr(644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man2/delete_module.2*
%attr(644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man2/get_kernel_syms.2*
%attr(644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man2/init_module.2*
%attr(644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man2/query_module.2*
%attr(644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man5/modules.conf.5*
%attr(644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man5/modules.5*
%attr(644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/depmod.8*
%attr(644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/genksyms.8*
%attr(644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/insmod.8*
#%attr(644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/kdstat.8*
#%attr(644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/kerneld.8*
%attr(644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/ksyms.8*
%attr(644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/lsmod.8*
%attr(644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/modinfo.8*
%attr(644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/modprobe.8*
%attr(644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/rmmod.8*
%attr(644,root,root) %doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/kallsyms.8*
%attr(-,root,root) %doc COPYING README CREDITS TODO ChangeLog NEWS example/kallsyms.c include/kallsyms.h
%attr(755,root,root) %config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/cron.daily/modutils
%attr(755,root,root) %config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/init.d/modutils
%attr(755,root,root) %config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/modules

%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/modutils


%changelog
* Wed May 7 2003 Daniel Jacobowitz <drow@mvista.com>
- Add support for DWARF information in MIPS kernel modules.
* Thu Sep 12 2002 Joe Green <source@mvista.com>
- Added support for Xtensa architecture.

* Fri Apr 20 2001 Steve Kinneberg <source@mvista.com>
- Added TCT package description files

* Tue Mar 06 2001 Jeremy Puhlman <jpuhlman@mvista.com>
- first-cut hhl spec file


